/*
 * Decompiled with CFR 0.152.
 */
package com.lvedy.alternative_twilight.networking;

import com.lvedy.alternative_twilight.entity.custom.SnowTrapEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.entity.boss.SnowQueen;

public class SnowQueenS2CPacket {
    private final float invincible;
    private final float frosty;
    private final float ice_armor;
    private final float explosion;
    private final float snow_trap;
    private final boolean big;
    private final String uuid;

    public SnowQueenS2CPacket(float invincible, float frosty, float ice_armor, float explosion, float snow_trap, boolean big, UUID uuid) {
        this.invincible = invincible;
        this.frosty = frosty;
        this.ice_armor = ice_armor;
        this.explosion = explosion;
        this.snow_trap = snow_trap;
        this.big = big;
        this.uuid = uuid.toString();
    }

    public SnowQueenS2CPacket(FriendlyByteBuf buf) {
        this.invincible = buf.readFloat();
        this.frosty = buf.readFloat();
        this.ice_armor = buf.readFloat();
        this.explosion = buf.readFloat();
        this.snow_trap = buf.readFloat();
        this.big = buf.readBoolean();
        this.uuid = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.invincible);
        buf.writeFloat(this.frosty);
        buf.writeFloat(this.ice_armor);
        buf.writeFloat(this.explosion);
        buf.writeFloat(this.snow_trap);
        buf.writeBoolean(this.big);
        buf.m_130070_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null) {
                UUID entityUUID = UUID.fromString(this.uuid);
                minecraft.f_91073_.m_104735_().forEach(entity -> {
                    if (entity.m_20148_().equals(entityUUID)) {
                        CompoundTag data = entity.getPersistentData();
                        if (entity instanceof SnowQueen) {
                            data.m_128405_("Invincible", (int)this.invincible);
                            data.m_128405_("Frosty", (int)this.frosty);
                            data.m_128405_("IceArmor", (int)this.ice_armor);
                            data.m_128405_("Explosion", (int)this.explosion);
                        }
                        if (entity instanceof SnowTrapEntity) {
                            data.m_128405_("LifeTime", (int)this.snow_trap);
                            data.m_128379_("Big", this.big);
                        }
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

