/*
 * Decompiled with CFR 0.152.
 */
package com.lvedy.alternative_twilight.networking;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.entity.boss.Minoshroom;

public class MinoshroomS2CPacket {
    private final int trackingTime;
    private final int targetSwitchCooldown;
    private final String uuid;

    public MinoshroomS2CPacket(int trackingTime, int targetSwitchCooldown, UUID uuid) {
        this.trackingTime = trackingTime;
        this.targetSwitchCooldown = targetSwitchCooldown;
        this.uuid = uuid.toString();
    }

    public MinoshroomS2CPacket(FriendlyByteBuf buf) {
        this.trackingTime = buf.readInt();
        this.targetSwitchCooldown = buf.readInt();
        this.uuid = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.trackingTime);
        buf.writeInt(this.targetSwitchCooldown);
        buf.m_130070_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null) {
                UUID entityUUID = UUID.fromString(this.uuid);
                minecraft.f_91073_.m_104735_().forEach(entity -> {
                    if (entity.m_20148_().equals(entityUUID) && entity instanceof Minoshroom) {
                        CompoundTag data = entity.getPersistentData();
                        data.m_128405_("TrackingTime", this.trackingTime);
                        data.m_128405_("TargetSwitchCooldown", this.targetSwitchCooldown);
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

