/*
 * Decompiled with CFR 0.152.
 */
package com.lvedy.alternative_twilight.mixin.SnowQueen;

import com.lvedy.alternative_twilight.ATModFinal;
import com.lvedy.alternative_twilight.entity.ModEntityTypes;
import com.lvedy.alternative_twilight.entity.custom.SnowTrapEntity;
import com.lvedy.alternative_twilight.networking.ModMessages;
import com.lvedy.alternative_twilight.networking.SnowQueenS2CPacket;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import twilightforest.entity.boss.SnowQueen;
import twilightforest.init.TFMobEffects;

@Mixin(value={SnowQueen.class}, priority=7)
public class SnowQueenMixin
extends Monster {
    @Unique
    private static final Predicate<Entity> IS_NOT_SELF = entity -> entity.m_6084_() && !(entity instanceof SnowQueen) && !(entity instanceof SnowTrapEntity);

    protected SnowQueenMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(DamageSource source, float damage, CallbackInfoReturnable<Boolean> cir) {
        CompoundTag pCompound = this.getPersistentData();
        if (pCompound.m_128451_("Invincible") > 0) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyArg(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/Monster;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"), index=1)
    public float HurtModify(float par2) {
        CompoundTag pCompound = this.getPersistentData();
        if (pCompound.m_128451_("Frosty") > 0 && pCompound.m_128451_("IceArmor") == 0) {
            return par2 * (1.0f - (float)ATModFinal.SnowQueenIceArmor / 100.0f);
        }
        return par2;
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    public void aiStep(CallbackInfo ci) {
        if (ATModFinal.SnowQueenModify == 1) {
            CompoundTag pCompound = this.getPersistentData();
            this.aTMod_forge_1_20_1$snowTrap(pCompound);
            this.aTMod_forge_1_20_1$forest(pCompound);
            this.aTMod_forge_1_20_1$snowExplosion(pCompound);
            this.aTMod_forge_1_20_1$iceArmor(pCompound);
            this.aTMod_forge_1_20_1$forestDamage();
            if (pCompound.m_128451_("IceTrap") > 0) {
                pCompound.m_128405_("IceTrap", pCompound.m_128451_("IceTrap") - 1);
            }
            if (pCompound.m_128451_("Frosty") > 0) {
                pCompound.m_128405_("Frosty", pCompound.m_128451_("Frosty") - 1);
            }
            if (pCompound.m_128451_("Invincible") > 0) {
                pCompound.m_128405_("Invincible", pCompound.m_128451_("Invincible") - 1);
            }
            this.aTMod_forge_1_20_1$sendData(pCompound);
        }
    }

    @Unique
    public void aTMod_forge_1_20_1$snowTrap(CompoundTag pCompound) {
        if (!pCompound.m_128441_("IceTrap")) {
            pCompound.m_128405_("IceTrap", ATModFinal.SnowQueenTrapCD);
        }
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (pCompound.m_128451_("IceTrap") == 0) {
            int i = pCompound.m_128451_("Frosty") <= 0 ? ATModFinal.SnowQueenTrapCount_1 : ATModFinal.SnowQueenTrapCount_2;
            while (i > 0) {
                List list = this.m_9236_().m_6443_(ServerPlayer.class, this.m_20191_().m_82400_(40.0), IS_NOT_SELF);
                for (ServerPlayer player : list) {
                    if (!player.f_8941_.m_9294_()) continue;
                    this.aTMod_forge_1_20_1$spawnTrap(pCompound, player.m_20182_());
                    --i;
                }
                if (i > 0) {
                    this.aTMod_forge_1_20_1$spawnTrap(pCompound, this.m_20182_());
                    --i;
                }
                while (i > 0) {
                    Vec3 vec3 = this.aTMod_forge_1_20_1$findVecInLOSOf((Entity)this.m_5448_());
                    this.aTMod_forge_1_20_1$spawnTrap(pCompound, vec3);
                    --i;
                }
            }
            if (pCompound.m_128451_("Frosty") <= 0) {
                pCompound.m_128405_("IceTrap", ATModFinal.SnowQueenTrapCD);
            } else {
                pCompound.m_128405_("IceTrap", (int)((double)ATModFinal.SnowQueenTrapCD * ATModFinal.SnowQueenTrapCDCD));
            }
        }
    }

    @Unique
    public void aTMod_forge_1_20_1$spawnTrap(CompoundTag pCompound, Vec3 vec3) {
        SnowTrapEntity snowTrapEntity = (SnowTrapEntity)((EntityType)ModEntityTypes.SNOW_TRAP.get()).m_20615_(this.m_9236_());
        if (snowTrapEntity != null) {
            if (pCompound.m_128451_("Frosty") > 0) {
                snowTrapEntity.setBig(true);
            }
            snowTrapEntity.m_6027_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            snowTrapEntity.m_9236_().m_7967_((Entity)snowTrapEntity);
        }
    }

    @Unique
    public void aTMod_forge_1_20_1$iceArmor(CompoundTag pCompound) {
        if (pCompound.m_128451_("IceArmor") > 0) {
            this.m_20242_(false);
            BlockState blockstate = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
            Block block = blockstate.m_60734_();
            if (block != Blocks.f_50016_) {
                this.m_21557_(true);
            }
            for (int i = 0; i < 5; ++i) {
                Vec3 pos = new Vec3(this.m_20185_(), this.m_20186_() + 2.15, this.m_20189_()).m_82549_(new Vec3(1.5, 0.0, 0.0).m_82524_((float)Math.toRadians(this.m_217043_().m_188503_(360))));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0, 0.0, 0.0);
            }
            pCompound.m_128405_("IceArmor", pCompound.m_128451_("IceArmor") - 1);
            if (pCompound.m_128451_("IceArmor") == 0) {
                this.m_20242_(true);
                this.m_21557_(false);
            }
        }
    }

    @Unique
    public void aTMod_forge_1_20_1$forest(CompoundTag pCompound) {
        if (pCompound.m_128451_("Invincible") > ATModFinal.SnowQueenInvincible + 60) {
            this.m_21153_(this.m_21233_() * 0.01f * (float)ATModFinal.SnowQueenHealthThreshold);
            this.m_21557_(true);
        } else if (pCompound.m_128451_("Invincible") > ATModFinal.SnowQueenInvincible) {
            this.m_21153_(this.m_21223_() + (float)ATModFinal.SnowQueenTreat / 60.0f);
            if (this.f_19796_.m_188503_(10) == 1) {
                this.aTMod_forge_1_20_1$snowParticle(1);
            }
        }
        if (pCompound.m_128451_("Invincible") == ATModFinal.SnowQueenInvincible) {
            this.aTMod_forge_1_20_1$snowParticle(0);
            this.m_21557_(false);
            List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(40.0), IS_NOT_SELF);
            for (LivingEntity entity : list) {
                entity.m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), ATModFinal.SnowQueenIceDuration, 0));
            }
        }
        if (this.m_21223_() <= this.m_21233_() * 0.01f * (float)ATModFinal.SnowQueenHealthThreshold && pCompound.m_128451_("Frosty") <= 0 && this.m_6084_()) {
            pCompound.m_128405_("Frosty", ATModFinal.SnowQueenIceCD);
            pCompound.m_128405_("Invincible", ATModFinal.SnowQueenInvincible + 120);
        }
    }

    @Unique
    public void aTMod_forge_1_20_1$forestDamage() {
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(40.0), IS_NOT_SELF);
        for (LivingEntity entity : list) {
            MobEffectInstance mobEffectInstance = entity.m_21124_((MobEffect)TFMobEffects.FROSTY.get());
            if (mobEffectInstance == null) continue;
            entity.m_6469_(this.m_269291_().m_269425_(), entity.m_21233_() * 0.01f * (float)ATModFinal.SnowQueenDamage);
        }
    }

    @Unique
    public void aTMod_forge_1_20_1$snowExplosion(CompoundTag pCompound) {
        if (!pCompound.m_128441_("Explosion")) {
            pCompound.m_128405_("Explosion", 0);
        } else if (pCompound.m_128451_("Explosion") == 1) {
            this.aTMod_forge_1_20_1$snowParticle(0);
            List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(10.0), IS_NOT_SELF);
            for (LivingEntity entity : list) {
                MobEffectInstance mobEffectInstance = entity.m_21124_((MobEffect)TFMobEffects.FROSTY.get());
                if (mobEffectInstance != null) {
                    entity.m_6469_(this.m_269291_().m_269425_(), (float)(Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22115_() * (double)ATModFinal.SnowQueenExplosionDamage));
                    continue;
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), 40, 0));
            }
        }
        if (pCompound.m_128451_("Explosion") > 0) {
            pCompound.m_128405_("Explosion", pCompound.m_128451_("Explosion") - 1);
        }
    }

    @Unique
    public void aTMod_forge_1_20_1$snowParticle(int type) {
        int i;
        if (type == 0) {
            for (i = 0; i < 200; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_() + 0.1 * (double)this.f_19796_.m_188503_(11), this.m_20189_(), 0.5 - 0.1 * (double)this.f_19796_.m_188503_(11), 0.5 - 0.15 * (double)this.f_19796_.m_188503_(11), 0.5 - 0.1 * (double)this.f_19796_.m_188503_(11));
            }
        }
        if (type == 1) {
            for (i = 0; i < 40; ++i) {
                Vec3 vec3 = new Vec3(this.m_20185_() + 0.5 * (double)this.f_19796_.m_188503_(11) - 0.5, this.m_20186_() + 0.5 * (double)this.f_19796_.m_188503_(11), this.m_20189_() + 0.5 * (double)this.f_19796_.m_188503_(11) - 0.5);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123754_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.5 - 0.1 * (double)this.f_19796_.m_188503_(11), 0.5 - 0.1 * (double)this.f_19796_.m_188503_(11), 0.5 - 0.1 * (double)this.f_19796_.m_188503_(11));
            }
        }
    }

    @Unique
    public void aTMod_forge_1_20_1$sendData(CompoundTag pCompound) {
        if (!this.m_9236_().m_5776_()) {
            ModMessages.sendToAllPlayers(new SnowQueenS2CPacket(pCompound.m_128451_("Invincible"), pCompound.m_128451_("Frosty"), pCompound.m_128451_("IceArmor"), pCompound.m_128451_("Explosion"), 0.0f, false, this.m_20148_()));
        }
    }

    @Unique
    @Nullable
    public Vec3 aTMod_forge_1_20_1$findVecInLOSOf(@Nullable Entity targetEntity) {
        if (targetEntity == null) {
            return this.m_20182_().m_82520_((double)(1 - this.f_19796_.m_188503_(7)), 0.0, (double)(1 - this.f_19796_.m_188503_(7)));
        }
        double origX = this.m_20185_();
        double origY = this.m_20186_();
        double origZ = this.m_20189_();
        int tries = 100;
        for (int i = 0; i < tries; ++i) {
            double tx = targetEntity.m_20185_() + this.m_217043_().m_188583_() * 16.0;
            double ty = targetEntity.m_20186_();
            double tz = targetEntity.m_20189_() + this.m_217043_().m_188583_() * 16.0;
            boolean destClear = this.m_20984_(tx, ty, tz, true);
            boolean canSeeTargetAtDest = this.m_142582_(targetEntity);
            this.m_6021_(origX, origY, origZ);
            if (!destClear || !canSeeTargetAtDest) continue;
            return new Vec3(tx, ty, tz);
        }
        return this.m_20182_().m_82520_((double)(1 + this.f_19796_.m_188503_(7)), 0.0, (double)(1 + this.f_19796_.m_188503_(7)));
    }
}

