/*
 * Decompiled with CFR 0.152.
 */
package com.lvedy.alternative_twilight.mixin.Minoshroom;

import com.lvedy.alternative_twilight.ATModFinal;
import com.lvedy.alternative_twilight.networking.MinoshroomS2CPacket;
import com.lvedy.alternative_twilight.networking.ModMessages;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import twilightforest.entity.boss.Minoshroom;
import twilightforest.entity.monster.Minotaur;
import twilightforest.init.TFSounds;

@Mixin(value={Minoshroom.class}, priority=7)
public abstract class MinoshroomMixin
extends Minotaur {
    @Unique
    private static final Predicate<Entity> IS_NOT_SELF = entity -> entity.m_6084_();
    @Unique
    private static final String BASE_ATTACK_TAG = "BaseAttack";
    @Unique
    private static final String BASE_MOVEMENT_SPEED_TAG = "BaseMovementSpeed";
    @Unique
    private static final String TRACKING_TIME_TAG = "TrackingTime";
    @Unique
    private static final String CURRENT_TARGET_TAG = "CurrentTarget";
    @Unique
    private static final String TARGET_SWITCH_COOLDOWN_TAG = "TargetSwitchCooldown";
    @Unique
    private static final String CAN_SWITCH_TARGET_TAG = "CanSwitchTarget";

    public MinoshroomMixin(EntityType<? extends Minotaur> type, Level world) {
        super(type, world);
    }

    @Shadow
    public abstract void setMaxCharge(int var1);

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    public void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (ATModFinal.MinoshroomModify == 1) {
            CompoundTag pCompound = this.getPersistentData();
            if (source.m_7639_() instanceof LivingEntity && !source.m_276093_(DamageTypes.f_268464_) && !source.m_276093_(DamageTypes.f_268566_)) {
                boolean canSwitchTarget;
                boolean bl = canSwitchTarget = pCompound.m_128441_(CAN_SWITCH_TARGET_TAG) ? pCompound.m_128471_(CAN_SWITCH_TARGET_TAG) : true;
                if (canSwitchTarget) {
                    this.m_6710_((LivingEntity)source.m_7639_());
                    pCompound.m_128405_(TARGET_SWITCH_COOLDOWN_TAG, ATModFinal.MinoshroomTargetSwitchCooldown);
                    pCompound.m_128379_(CAN_SWITCH_TARGET_TAG, false);
                }
            }
            if (this.m_5448_() != null && source.m_7639_() == this.m_5448_()) {
                pCompound.m_128350_("ExtraDamage", 1.0f - (float)ATModFinal.MinoshroomReduceDamage / 100.0f);
            } else {
                pCompound.m_128350_("ExtraDamage", 1.0f + (float)ATModFinal.MinoshroomAddDamage / 100.0f);
            }
        }
    }

    @ModifyArg(method={"hurt"}, at=@At(value="INVOKE", target="Ltwilightforest/entity/monster/Minotaur;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"), index=1)
    public float Hurt(float par1) {
        if (ATModFinal.MinoshroomModify == 1) {
            CompoundTag pCompound = this.getPersistentData();
            if (pCompound.m_128441_("ExtraDamage")) {
                par1 *= pCompound.m_128457_("ExtraDamage");
                pCompound.m_128350_("ExtraDamage", 1.0f);
            }
            return par1;
        }
        return par1;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (ATModFinal.MinoshroomModify == 1) {
            CompoundTag pCompound = this.getPersistentData();
            this.aTMod_forge_1_20_1$initializeBaseAttributes(pCompound);
            if (!(!(this.m_21223_() <= this.m_21233_() * 0.01f * (float)ATModFinal.MinoshroomHealthThreshold) || pCompound.m_128441_("Treat") && pCompound.m_128471_("Treat"))) {
                pCompound.m_128379_("Treat", true);
                this.m_21051_(Attributes.f_22284_).m_22100_(this.m_21172_(Attributes.f_22284_) + (double)ATModFinal.MinoshroomArmor);
                this.m_21051_(Attributes.f_22285_).m_22100_(this.m_21172_(Attributes.f_22285_) + (double)ATModFinal.MinoshroomArmorToughness);
                this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) + (double)ATModFinal.MinoshroomHealth);
                this.m_21153_(this.m_21233_());
                List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(5.0), IS_NOT_SELF);
                for (LivingEntity entity : list) {
                    Vec3 vec3 = this.m_20182_();
                    Vec3 vec32 = entity.m_20182_().m_82546_(vec3);
                    Vec3 vec33 = vec32.m_82541_();
                    entity.m_5997_(vec33.m_7096_() * 1.5, 0.2, vec33.m_7094_() * 1.5);
                }
                if (ATModFinal.MinoshroomWarcryBreakBlocks == 1 && !this.m_9236_().m_5776_()) {
                    this.aTMod_forge_1_20_1$breakBlocksAround();
                }
            }
            this.aTMod_forge_1_20_1$updateTargetSwitchCooldown(pCompound);
            if (this.m_9236_().m_5776_()) {
                this.aTMod_forge_1_20_1$spawnParticlesBasedOnTrackingTime(pCompound.m_128451_(TRACKING_TIME_TAG));
                if (pCompound.m_128441_(CAN_SWITCH_TARGET_TAG) && pCompound.m_128471_(CAN_SWITCH_TARGET_TAG) && pCompound.m_128441_(TARGET_SWITCH_COOLDOWN_TAG) && pCompound.m_128451_(TARGET_SWITCH_COOLDOWN_TAG) == 1) {
                    this.aTMod_forge_1_20_1$spawnAngerParticles();
                }
            } else {
                this.aTMod_forge_1_20_1$sendDataToClient(pCompound);
                this.aTMod_forge_1_20_1$updateTrackingBuffs(pCompound);
            }
        }
    }

    @Unique
    private void aTMod_forge_1_20_1$initializeBaseAttributes(CompoundTag pCompound) {
        if (!pCompound.m_128441_(BASE_ATTACK_TAG)) {
            AttributeInstance attackAttribute = this.m_21051_(Attributes.f_22281_);
            AttributeInstance movementSpeedAttribute = this.m_21051_(Attributes.f_22279_);
            if (attackAttribute != null && movementSpeedAttribute != null) {
                double baseAttack = attackAttribute.m_22115_();
                double baseMovementSpeed = movementSpeedAttribute.m_22115_();
                pCompound.m_128347_(BASE_ATTACK_TAG, baseAttack);
                pCompound.m_128347_(BASE_MOVEMENT_SPEED_TAG, baseMovementSpeed);
                pCompound.m_128405_(TRACKING_TIME_TAG, 0);
            }
        }
    }

    @Unique
    private void aTMod_forge_1_20_1$updateTrackingBuffs(CompoundTag pCompound) {
        LivingEntity currentTarget = this.m_5448_();
        if (currentTarget == null) {
            this.aTMod_forge_1_20_1$resetTrackingBuffs(pCompound, true);
        } else {
            if (pCompound.m_128441_(CURRENT_TARGET_TAG)) {
                String currentTargetUUID;
                String savedTargetUUID = pCompound.m_128461_(CURRENT_TARGET_TAG);
                if (!savedTargetUUID.equals(currentTargetUUID = currentTarget.m_20149_())) {
                    this.aTMod_forge_1_20_1$resetTrackingBuffs(pCompound, false);
                    pCompound.m_128359_(CURRENT_TARGET_TAG, currentTargetUUID);
                }
            } else {
                pCompound.m_128359_(CURRENT_TARGET_TAG, currentTarget.m_20149_());
            }
            int currentTrackingTime = pCompound.m_128451_(TRACKING_TIME_TAG);
            if (currentTrackingTime < ATModFinal.MinoshroomTrackingMaxTime) {
                pCompound.m_128405_(TRACKING_TIME_TAG, ++currentTrackingTime);
                this.aTMod_forge_1_20_1$updateAttributesBasedOnTrackingTime(pCompound, currentTrackingTime);
            }
        }
    }

    @Unique
    private void aTMod_forge_1_20_1$resetTrackingBuffs(CompoundTag pCompound, boolean fullReset) {
        int currentTrackingTime = pCompound.m_128451_(TRACKING_TIME_TAG);
        if (fullReset) {
            pCompound.m_128405_(TRACKING_TIME_TAG, 0);
            if (pCompound.m_128441_(CURRENT_TARGET_TAG)) {
                pCompound.m_128473_(CURRENT_TARGET_TAG);
            }
        } else {
            int newTrackingTime = (int)((double)currentTrackingTime * (1.0 - (double)ATModFinal.MinoshroomBuffLossPercent / 100.0));
            pCompound.m_128405_(TRACKING_TIME_TAG, newTrackingTime);
        }
        this.aTMod_forge_1_20_1$updateAttributesBasedOnTrackingTime(pCompound, pCompound.m_128451_(TRACKING_TIME_TAG));
    }

    @Unique
    private void aTMod_forge_1_20_1$updateAttributesBasedOnTrackingTime(CompoundTag pCompound, int trackingTime) {
        if (!pCompound.m_128441_(BASE_ATTACK_TAG)) {
            return;
        }
        double baseAttack = pCompound.m_128459_(BASE_ATTACK_TAG);
        double baseMovementSpeed = pCompound.m_128459_(BASE_MOVEMENT_SPEED_TAG);
        double progressFactor = Math.min(1.0, (double)trackingTime / (double)ATModFinal.MinoshroomTrackingMaxTime);
        double attackMultiplier = 1.0 + (double)(ATModFinal.MinoshroomAttackMultiplier - 100) / 100.0 * progressFactor;
        double movementSpeedMultiplier = 1.0 + (double)(ATModFinal.MinoshroomSpeedMultiplier - 100) / 100.0 * progressFactor;
        AttributeInstance attackAttribute = this.m_21051_(Attributes.f_22281_);
        AttributeInstance movementSpeedAttribute = this.m_21051_(Attributes.f_22279_);
        if (attackAttribute != null) {
            attackAttribute.m_22100_((baseAttack + (double)MinoshroomMixin.aTMod_forge_1_20_1$getWeaponAttackDamage(this.m_21205_())) * attackMultiplier - (double)MinoshroomMixin.aTMod_forge_1_20_1$getWeaponAttackDamage(this.m_21205_()));
        }
        if (movementSpeedAttribute != null) {
            movementSpeedAttribute.m_22100_(baseMovementSpeed * movementSpeedMultiplier);
        }
    }

    @Unique
    private void aTMod_forge_1_20_1$spawnParticlesBasedOnTrackingTime(int trackingTime) {
        if (trackingTime > 0) {
            int particleCount = (int)((double)trackingTime / 100.0) + 1;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = this.f_19796_.m_188583_() * 0.2;
                double offsetY = this.f_19796_.m_188583_() * 0.2 + 1.0;
                double offsetZ = this.f_19796_.m_188583_() * 0.2;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.5, 0.0, 0.0);
            }
        }
    }

    @Unique
    private void aTMod_forge_1_20_1$updateTargetSwitchCooldown(CompoundTag pCompound) {
        if (!pCompound.m_128441_(TARGET_SWITCH_COOLDOWN_TAG)) {
            pCompound.m_128405_(TARGET_SWITCH_COOLDOWN_TAG, 0);
            pCompound.m_128379_(CAN_SWITCH_TARGET_TAG, true);
        }
        int cooldown = pCompound.m_128451_(TARGET_SWITCH_COOLDOWN_TAG);
        boolean canSwitchTarget = pCompound.m_128471_(CAN_SWITCH_TARGET_TAG);
        if (cooldown > 0) {
            pCompound.m_128405_(TARGET_SWITCH_COOLDOWN_TAG, --cooldown);
            if (cooldown == 0 && !canSwitchTarget) {
                pCompound.m_128379_(CAN_SWITCH_TARGET_TAG, true);
                if (!this.m_9236_().m_5776_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)TFSounds.MINOSHROOM_SLAM.get(), SoundSource.HOSTILE, 1.0f, 0.5f);
                }
            }
        }
    }

    @Unique
    private void aTMod_forge_1_20_1$spawnAngerParticles() {
        for (int i = 0; i < 20; ++i) {
            double offsetX = this.f_19796_.m_188583_() * 0.3;
            double offsetY = this.f_19796_.m_188583_() * 0.3 + 1.0;
            double offsetZ = this.f_19796_.m_188583_() * 0.3;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    @Unique
    private void aTMod_forge_1_20_1$sendDataToClient(CompoundTag pCompound) {
        if (!this.m_9236_().m_5776_()) {
            int trackingTime = pCompound.m_128451_(TRACKING_TIME_TAG);
            int targetSwitchCooldown = pCompound.m_128451_(TARGET_SWITCH_COOLDOWN_TAG);
            ModMessages.sendToAllPlayers(new MinoshroomS2CPacket(trackingTime, targetSwitchCooldown, this.m_20148_()));
        }
    }

    @Unique
    private void aTMod_forge_1_20_1$breakBlocksAround() {
        int radius = ATModFinal.MinoshroomBreakBlocksRadius;
        int height = ATModFinal.MinoshroomBreakBlocksHeight;
        BlockPos center = this.m_20183_();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -1; y <= height; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockState state;
                    BlockPos pos = center.m_7918_(x, y, z);
                    double distSq = x * x + z * z;
                    if (!(distSq <= (double)(radius * radius)) || (state = this.m_9236_().m_8055_(pos)).m_60795_() || !(state.m_60800_((BlockGetter)this.m_9236_(), pos) >= 0.0f) || !(state.m_60800_((BlockGetter)this.m_9236_(), pos) < 50.0f)) continue;
                    this.m_9236_().m_46961_(pos, true);
                }
            }
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)TFSounds.MINOSHROOM_SLAM.get(), SoundSource.HOSTILE, 1.5f, 0.8f);
    }

    @Unique
    private static float aTMod_forge_1_20_1$getWeaponAttackDamage(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            return sword.m_43299_();
        }
        if (item instanceof AxeItem) {
            AxeItem axe = (AxeItem)item;
            return axe.m_41008_();
        }
        return 0.0f;
    }
}

