/*
 * Decompiled with CFR 0.152.
 */
package com.lvedy.alternative_twilight.entity.custom;

import com.lvedy.alternative_twilight.ATModFinal;
import com.lvedy.alternative_twilight.networking.ModMessages;
import com.lvedy.alternative_twilight.networking.SnowQueenS2CPacket;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import twilightforest.entity.boss.SnowQueen;
import twilightforest.init.TFMobEffects;

public class SnowTrapEntity
extends Mob {
    private static final Predicate<Entity> IS_NOT_SNOW = entity -> entity.m_6084_() && !(entity instanceof SnowQueen) && !(entity instanceof SnowTrapEntity);
    private static final Predicate<Entity> IS_NOT_SELF = entity -> entity.m_6084_() && !(entity instanceof SnowTrapEntity);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private static final String LIFETIME_TAG = "LifeTime";
    private static final String BIG_TAG = "Big";

    public SnowTrapEntity(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(false);
        CompoundTag tag = this.getPersistentData();
        tag.m_128405_(LIFETIME_TAG, 140);
        tag.m_128379_(BIG_TAG, false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
            this.particle();
        } else {
            CompoundTag tag = this.getPersistentData();
            if (this.getLifeTime() > 0) {
                this.setLifetime(this.getLifeTime() - 1);
            }
            this.frosty(tag);
            this.sendData(tag);
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 100;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_276093_(DamageTypes.f_286979_)) {
            return false;
        }
        super.m_6469_(pSource, pAmount);
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 0.0);
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_7337_(Entity pEntity) {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_20971_) {
    }

    public void m_147240_(double strength, double xRatio, double zRatio) {
    }

    public void particle() {
        if (this.m_9236_().f_46443_) {
            ClientLevel level = (ClientLevel)this.m_9236_();
            double offsetX = this.f_19796_.m_188583_() * 0.5;
            double offsetZ = this.f_19796_.m_188583_() * 0.5;
            SimpleParticleType particle = ParticleTypes.f_175821_;
            level.m_7106_((ParticleOptions)particle, this.m_20185_() + offsetX, this.m_20186_() + 0.1, this.m_20189_() + offsetZ, 0.0, 0.1, 0.0);
        }
        if (this.getLifeTime() == 1) {
            for (int i = 0; i < 200; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_() + 0.1 * (double)this.f_19796_.m_188503_(11), this.m_20189_(), 0.2 - 0.04 * (double)this.f_19796_.m_188503_(11), 0.08 * (double)this.f_19796_.m_188503_(11), 0.2 - 0.04 * (double)this.f_19796_.m_188503_(11));
            }
        }
    }

    public void setLifetime(int lifetime) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(LIFETIME_TAG, lifetime);
        this.getPersistentData().m_128391_(tag);
    }

    public int getLifeTime() {
        return this.getPersistentData().m_128451_(LIFETIME_TAG);
    }

    public void setBig(boolean big) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(BIG_TAG, big);
        this.getPersistentData().m_128391_(tag);
    }

    public boolean getBig() {
        return this.getPersistentData().m_128471_(BIG_TAG);
    }

    public void frosty(CompoundTag pCompound) {
        int i = 1;
        if (this.getBig()) {
            i = ATModFinal.SnowTrapScale;
        }
        if (pCompound.m_128451_(LIFETIME_TAG) == 0) {
            List list = this.m_9236_().m_6443_(LivingEntity.class, new AABB(this.m_20182_().m_82520_((double)(-i), 0.0, (double)(-i)), this.m_20182_().m_82520_((double)i, 8.0, (double)i)), IS_NOT_SELF);
            for (LivingEntity entity : list) {
                if (entity instanceof SnowQueen) {
                    CompoundTag tag = entity.getPersistentData();
                    tag.m_128405_("Explosion", 10);
                    if (tag.m_128451_("Frosty") <= 0) continue;
                    tag.m_128405_("IceArmor", 100);
                    continue;
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), 100, 0));
            }
            this.m_146870_();
        }
    }

    public void sendData(CompoundTag pCompound) {
        if (!this.m_9236_().m_5776_()) {
            ModMessages.sendToAllPlayers(new SnowQueenS2CPacket(0.0f, 0.0f, 0.0f, 0.0f, pCompound.m_128451_(LIFETIME_TAG), pCompound.m_128471_(BIG_TAG), this.m_20148_()));
        }
    }
}

