/*
 * Decompiled with CFR 0.152.
 */
package com.lvedy.alternative_twilight.Render.SnowQueen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.entity.boss.SnowQueen;

@OnlyIn(value=Dist.CLIENT)
public class SnowQueenLayer<T extends SnowQueen, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation POWER_LOCATION = new ResourceLocation("alternative_twilight", "textures/entity/snow_queen/snow_queen_armor.png");
    private static final ResourceLocation ICE_ARMOR_LOCATION = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private final EntityModel<T> model;
    CompoundTag pCompound = new CompoundTag();

    public SnowQueenLayer(RenderLayerParent<T, M> pRenderer, EntityModel<T> model) {
        super(pRenderer);
        this.model = model;
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.pCompound = pLivingEntity.getPersistentData();
        if (this.pCompound.m_128451_("Invincible") > 0 || this.pCompound.m_128451_("Frosty") > 0 && this.pCompound.m_128451_("IceArmor") == 0) {
            float f = (float)((SnowQueen)pLivingEntity).f_19797_ + pPartialTicks;
            EntityModel<T> entitymodel = this.model();
            entitymodel.m_6839_(pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks);
            this.m_117386_().m_102624_(entitymodel);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110436_((ResourceLocation)this.getTextureLocation(), (float)(this.xOffset(f) % 1.0f), (float)0.0f));
            entitymodel.m_6973_(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            entitymodel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 0.5f, 0.5f, 0.5f, 1.0f);
        }
    }

    protected float xOffset(float pTickCount) {
        return pTickCount * 0.01f;
    }

    protected ResourceLocation getTextureLocation() {
        if (this.pCompound.m_128451_("Invincible") > 0) {
            return POWER_LOCATION;
        }
        return ICE_ARMOR_LOCATION;
    }

    protected EntityModel<T> model() {
        return this.model;
    }
}

