/*
 * Decompiled with CFR 0.152.
 */
package com.lvedy.alternative_twilight.Render.Lich;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.entity.boss.Lich;

@OnlyIn(value=Dist.CLIENT)
public class LichPowerLayer<T extends Lich, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation POWER_LOCATION = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private final EntityModel<T> model;

    public LichPowerLayer(RenderLayerParent<T, M> pRenderer, EntityModel<T> model) {
        super(pRenderer);
        this.model = model;
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        CompoundTag pCompound = pLivingEntity.getPersistentData();
        if (pLivingEntity.getPhase() != 1 && pCompound.m_128441_("ExtraArmor") && pCompound.m_128457_("ExtraArmor") > 0.0f) {
            float f = (float)((Lich)pLivingEntity).f_19797_ + pPartialTicks;
            EntityModel<T> entitymodel = this.model();
            entitymodel.m_6839_(pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks);
            this.m_117386_().m_102624_(entitymodel);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110436_((ResourceLocation)this.getTextureLocation(), (float)(this.xOffset(f) % 1.0f), (float)(f * 0.01f % 1.0f)));
            entitymodel.m_6973_(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            entitymodel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 0.5f, 0.5f, 0.5f, pCompound.m_128457_("ExtraArmor") / 80.0f);
        }
    }

    protected float xOffset(float pTickCount) {
        return pTickCount * 0.01f;
    }

    protected ResourceLocation getTextureLocation() {
        return POWER_LOCATION;
    }

    protected EntityModel<T> model() {
        return this.model;
    }
}

