/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.events;

import com.xiaoyue.celestial_core.content.generic.PlayerFlagData;
import com.xiaoyue.celestial_core.register.CCAttributes;
import com.xiaoyue.celestial_core.register.CCEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="celestial_core", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CCGeneralEventHandler {
    public static String NETHER_STAGE = "nether_stage";

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            double re = player.m_21133_((Attribute)CCAttributes.REPLY_POWER.get());
            event.setAmount((float)((double)event.getAmount() * re));
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        AbstractArrow arrow;
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity2).m_19749_()) instanceof Player) {
            Player player = (Player)entity;
            double as = player.m_21133_((Attribute)CCAttributes.ARROW_SPEED.get());
            double ak = player.m_21133_((Attribute)CCAttributes.ARROW_KNOCK.get());
            if (!arrow.m_19880_().contains("arrow_speed")) {
                arrow.m_20256_(arrow.m_20184_().m_82490_(as));
                arrow.m_20049_("arrow_speed");
            }
            arrow.m_36735_(arrow.m_150123_() + (int)ak);
        }
    }

    @SubscribeEvent
    public static void onLivingTeleport(EntityTeleportEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)CCEffects.ROTTEN_CURSE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            PlayerFlagData data = (PlayerFlagData)PlayerFlagData.HOLDER.get(player);
            if (entity instanceof WitherBoss && !data.hasFlag(NETHER_STAGE)) {
                data.addFlag(NETHER_STAGE);
            }
        }
    }
}

