/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_overhaul.event;

import com.xiaoyue.celestial_overhaul.content.EffectOverrideHandler;
import com.xiaoyue.celestial_overhaul.content.OverhaulUtils;
import com.xiaoyue.celestial_overhaul.content.WeaponBlockHandler;
import com.xiaoyue.celestial_overhaul.data.COModConfig;
import com.xiaoyue.celestial_overhaul.data.COTagGen;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="celestial_overhaul", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class COGeneralEventHandler {
    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EffectOverrideHandler.check();
        }
    }

    @SubscribeEvent
    public static void onBlockedHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (WeaponBlockHandler.isBlocking(entity)) {
            ItemStack stack = entity.m_21205_();
            float modifier = WeaponBlockHandler.getHurtModifier(stack, entity, event.getSource());
            event.setAmount(event.getAmount() * modifier);
            stack.m_41622_(WeaponBlockHandler.getItemDamaged(stack), entity, e -> e.m_21190_(InteractionHand.MAIN_HAND));
        }
    }

    @SubscribeEvent
    public static void onCritHit(CriticalHitEvent event) {
        if (!event.isVanillaCritical() || event.getResult().equals((Object)Event.Result.ALLOW)) {
            return;
        }
        if (!((Boolean)COModConfig.COMMON.canVanillaCritical.get()).booleanValue()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Double config;
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntity();
        if (source.m_7639_() != null || source.m_7640_() != null || entity.m_6095_().m_204039_(COTagGen.DAMAGE_SCALING_BLACK_LIST)) {
            return;
        }
        if (source.m_276093_(DamageTypes.f_268441_) && (config = (Double)COModConfig.COMMON.playerHungryDamageTweak.get()) >= 0.0) {
            event.setAmount(event.getAmount() * Math.max(1.0f, entity.m_21233_() * config.floatValue()));
        }
        if (source.m_276093_(DamageTypes.f_268671_) && (config = (Double)COModConfig.COMMON.entityFallDamageTweak.get()) >= 0.0) {
            event.setAmount(event.getAmount() * Math.max(1.0f, entity.m_21233_() * config.floatValue()));
        }
        if ((source.m_276093_(DamageTypes.f_268613_) || source.m_276093_(DamageTypes.f_268612_)) && (config = (Double)COModConfig.COMMON.entityCrammingDamageTweak.get()) >= 0.0) {
            event.setAmount(event.getAmount() * Math.max(1.0f, entity.m_21233_() * config.floatValue()));
        }
        if (source.m_276093_(DamageTypes.f_268722_) && (config = (Double)COModConfig.COMMON.entityDrownDamageTweak.get()) >= 0.0) {
            event.setAmount(event.getAmount() * Math.max(1.0f, entity.m_21233_() * config.floatValue()));
        }
        if (source.m_269533_(DamageTypeTags.f_268745_) && (config = (Double)COModConfig.COMMON.fireTypeDamageTweak.get()) >= 0.0) {
            event.setAmount(event.getAmount() * Math.max(1.0f, entity.m_21233_() * config.floatValue()));
        }
    }

    @SubscribeEvent
    public static void onHurtLiving(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntity();
        Entity entity2 = source.m_7639_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity2;
        if (source.m_7640_() != null && source.m_7640_().equals((Object)attacker)) {
            Double killerConfig;
            ItemStack stack = attacker.m_21205_();
            Double sharpnessConfig = (Double)COModConfig.COMMON.sharpnessEnchantmentBonus.get();
            int sharpnessLv = stack.getEnchantmentLevel(Enchantments.f_44977_);
            if (sharpnessLv > 0 && sharpnessConfig >= 0.0) {
                event.setAmount(event.getAmount() * (1.0f + sharpnessConfig.floatValue() * (float)sharpnessLv));
            }
            if ((killerConfig = (Double)COModConfig.COMMON.killerEnchantmentBonus.get()) >= 0.0) {
                int boaLv;
                int smiteLv = stack.getEnchantmentLevel(Enchantments.f_44978_);
                if (smiteLv > 0 && entity.m_6336_().equals(MobType.f_21641_)) {
                    event.setAmount(event.getAmount() * (1.0f + killerConfig.floatValue() * (float)smiteLv));
                }
                if ((boaLv = stack.getEnchantmentLevel(Enchantments.f_44979_)) > 0 && entity.m_6336_().equals(MobType.f_21642_)) {
                    event.setAmount(event.getAmount() * (1.0f + killerConfig.floatValue() * (float)boaLv));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Predicate<Entity> filter;
        Player player = event.getEntity();
        if (!OverhaulUtils.canGrassPierce(player, event.getLevel(), event.getPos())) {
            return;
        }
        double distance = Math.max(player.getBlockReach(), player.getEntityReach());
        EntityHitResult result = OverhaulUtils.rayTraceEntity(player, 1.0f, distance, filter = EntitySelector.f_20406_.and(e -> e != null && e.m_6087_() && e instanceof LivingEntity && !(e instanceof FakePlayer) && !OverhaulUtils.getVehicle(player).contains(e)));
        if (result != null && !event.getLevel().m_5776_()) {
            player.m_5706_(result.m_82443_());
            player.m_36334_();
        }
    }

    @SubscribeEvent
    public static void onArrowImpact(ProjectileImpactEvent event) {
        if (!((Boolean)COModConfig.COMMON.arrowHitMobSound.get()).booleanValue()) {
            return;
        }
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)projectile;
        HitResult result = event.getRayTraceResult();
        Entity entity = arrow.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (result.m_6662_().equals((Object)HitResult.Type.ENTITY)) {
                EntityHitResult hit = (EntityHitResult)result;
                if (hit.m_82443_() instanceof Player) {
                    return;
                }
                arrow.m_5496_(SoundEvents.f_11686_, 1.0f, 1.2f / (player.m_217043_().m_188501_() * 0.2f + 0.9f));
            }
        }
    }
}

