/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.events;

import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.init.data.LangData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="cuisinedelight")
public class EventListeners {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(stack);
        if (config == null) {
            return;
        }
        if (Screen.m_96638_()) {
            event.getToolTip().add(config.type.get().m_130940_(ChatFormatting.GOLD));
            event.getToolTip().add(LangData.INFO_SIZE.get(config.size));
            event.getToolTip().add(LangData.INFO_NUTRITION.get(config.nutrition));
            event.getToolTip().add(LangData.INFO_MIN_TIME.get(config.min_time / 20));
            event.getToolTip().add(LangData.INFO_MAX_TIME.get(config.max_time / 20));
            event.getToolTip().add(LangData.INFO_STIR_TIME.get(config.stir_time / 20));
            event.getToolTip().add(LangData.INFO_RAW_PENALTY.get(Math.round(config.raw_penalty * 100.0f)));
            event.getToolTip().add(LangData.INFO_OVERCOOK_PENALTY.get(Math.round(config.overcook_penalty * 100.0f)));
            for (IngredientConfig.EffectEntry e : config.effects) {
                MobEffectInstance mobeffectinstance = new MobEffectInstance(e.effect(), e.time());
                MutableComponent mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
                MobEffect mobeffect = mobeffectinstance.m_19544_();
                if (mobeffectinstance.m_19557_() > 20) {
                    mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)mobeffectinstance, (float)1.0f)});
                }
                event.getToolTip().add(mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
            }
        } else {
            event.getToolTip().add(LangData.SHIFT.get(new Object[0]));
        }
    }
}

