/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.recipe;

import dev.xkmc.cuisinedelight.content.item.BaseFoodItem;
import dev.xkmc.cuisinedelight.content.logic.CookedFoodData;
import dev.xkmc.cuisinedelight.content.recipe.CuisineRecipeContainer;
import dev.xkmc.cuisinedelight.content.recipe.CuisineRecipeMatch;
import dev.xkmc.cuisinedelight.init.registrate.CDMisc;
import dev.xkmc.l2library.serial.recipe.BaseRecipe;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

@SerialClass
public class BaseCuisineRecipe<R extends BaseCuisineRecipe<R>>
extends BaseRecipe<R, BaseCuisineRecipe<?>, CuisineRecipeContainer> {
    @SerialClass.SerialField
    public final ArrayList<CuisineRecipeMatch> list = new ArrayList();
    @SerialClass.SerialField
    public double saturationBonus;
    @SerialClass.SerialField
    public double saturationBonusModifier;
    @SerialClass.SerialField
    public Item holderItem;

    public static ItemStack findBestMatch(Level level, CookedFoodData food) {
        CuisineRecipeContainer inv = new CuisineRecipeContainer(food);
        List list = level.m_7465_().m_44056_((RecipeType)CDMisc.RT_CUISINE.get(), (Container)inv, level);
        BaseCuisineRecipe ans = null;
        double score = -1.0;
        for (BaseCuisineRecipe r : list) {
            double s = r.getScore(inv);
            if (!(s > score)) continue;
            score = s;
            ans = r;
        }
        assert (ans != null);
        ItemStack result = ans.assemble(inv, level.m_9598_());
        food.nutrition = (int)((double)food.nutrition * (1.0 + ans.saturationBonusModifier * (score -= ans.getScoreOffset())));
        BaseFoodItem.setData(result, food);
        return result;
    }

    public BaseCuisineRecipe(ResourceLocation id, BaseRecipe.RecType<R, BaseCuisineRecipe<?>, CuisineRecipeContainer> fac) {
        super(id, fac);
    }

    public boolean matches(CuisineRecipeContainer cont, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(cont.list);
        for (CuisineRecipeMatch match : this.list) {
            if (match.reduce(inputs) != 0.0) continue;
            return false;
        }
        return true;
    }

    public double getScore(CuisineRecipeContainer cont) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(cont.list);
        double ans = 0.0;
        for (CuisineRecipeMatch match : this.list) {
            ans += match.reduce(inputs);
        }
        return ans;
    }

    public ItemStack assemble(CuisineRecipeContainer cont, RegistryAccess access) {
        return this.holderItem.m_7968_();
    }

    public boolean m_8004_(int i, int i1) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        Item item = this.holderItem;
        if (item instanceof BaseFoodItem) {
            BaseFoodItem food = (BaseFoodItem)item;
            return food.displayStack(this);
        }
        return this.holderItem.m_7968_();
    }

    private double getScoreOffset() {
        double ans = 0.0;
        for (CuisineRecipeMatch e : this.list) {
            ans += e.score();
        }
        return ans;
    }

    public double getMinSaturationBonus() {
        return this.saturationBonus;
    }

    public double getMaxSaturationBonus() {
        double ans = this.saturationBonus;
        for (CuisineRecipeMatch e : this.list) {
            ans += this.saturationBonusModifier * e.bonus();
        }
        return ans;
    }
}

