/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class FluidRenderer {
    public static VertexConsumer getFluidBuilder(MultiBufferSource buffer) {
        return buffer.m_6299_(RenderTypes.FLUID);
    }

    public static void renderWaterBox(float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, int colorOverride) {
        FluidRenderer.renderFluidBox(new FluidStack((Fluid)Fluids.f_76193_, 1000), xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false, colorOverride);
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom, int colorOverride) {
        FluidRenderer.renderFluidBox(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderer.getFluidBuilder(buffer), ms, light, renderBottom, colorOverride);
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom, int colorOverride) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        FluidType fluidAttributes = fluid.getFluidType();
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(clientFluid.getStillTexture(fluidStack));
        int color = clientFluid.getTintColor(fluidStack);
        if (colorOverride != 0) {
            color = colorOverride;
        }
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidAttributes.getLightLevel(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        ms.m_85836_();
        for (Direction side : Direction.values()) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (side.m_122434_().m_122479_()) {
                if (side.m_122434_() == Direction.Axis.X) {
                    FluidRenderer.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, ms, light, color, fluidTexture);
                    continue;
                }
                FluidRenderer.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, ms, light, color, fluidTexture);
                continue;
            }
            FluidRenderer.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, ms, light, color, fluidTexture);
        }
        ms.m_85849_();
    }

    public static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        FluidRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    public static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.m_122421_() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.m_122434_().m_122479_();
        boolean x = dir.m_122434_() == Direction.Axis.X;
        float shrink = texture.m_118417_() * 0.25f * textureScale;
        float centerU = texture.m_118409_() + (texture.m_118410_() - texture.m_118409_()) * 0.5f * textureScale;
        float centerV = texture.m_118411_() + (texture.m_118412_() - texture.m_118411_()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.m_14143_((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir != Direction.NORTH && dir != Direction.EAST) {
                u1 = texture.m_118367_((double)((x1 - f) * 16.0f * textureScale));
                u2 = texture.m_118367_((double)((x2 - f) * 16.0f * textureScale));
            } else {
                f = Mth.m_14167_((float)x2);
                u1 = texture.m_118367_((double)((f - x2) * 16.0f * textureScale));
                u2 = texture.m_118367_((double)((f - x1) * 16.0f * textureScale));
            }
            u1 = Mth.m_14179_((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.m_14179_((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.m_14143_((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.m_118393_((double)((y1 - f) * 16.0f * textureScale));
                    v2 = texture.m_118393_((double)((y2 - f) * 16.0f * textureScale));
                } else {
                    f = Mth.m_14167_((float)y2);
                    v1 = texture.m_118393_((double)((f - y2) * 16.0f * textureScale));
                    v2 = texture.m_118393_((double)((f - y1) * 16.0f * textureScale));
                }
                v1 = Mth.m_14179_((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.m_14179_((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        FluidRenderer.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        FluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    FluidRenderer.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    FluidRenderer.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    FluidRenderer.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    FluidRenderer.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.m_122436_();
        PoseStack.Pose peek = ms.m_85850_();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.m_252986_(peek.m_252922_(), x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(peek.m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }

    private static class RenderTypes
    extends RenderStateShard {
        private static final RenderType FLUID = RenderType.m_173215_((String)RenderTypes.createLayerName("fluid"), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173065_).m_173290_((RenderStateShard.EmptyTextureStateShard)f_110145_).m_110685_(f_110139_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true));

        private static String createLayerName(String name) {
            return "cuisinedelight:" + name;
        }

        public RenderTypes(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
            super(p_110161_, p_110162_, p_110163_);
        }
    }
}

