/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.cuisinedelight.content.client.FluidRenderer;
import dev.xkmc.cuisinedelight.content.logic.transform.FluidTransform;
import net.minecraft.client.renderer.MultiBufferSource;

public class FluidRenderHelper {
    int count;
    int alpha;
    int red;
    int green;
    int blue;

    public void addFluid(FluidTransform fluid) {
        int color = fluid.color();
        int ca = color >> 24 & 0xFF;
        int cr = color >> 16 & 0xFF;
        int cg = color >> 8 & 0xFF;
        int cb = color & 0xFF;
        this.alpha += ca;
        this.red += cr * ca;
        this.green += cg * ca;
        this.blue += cb * ca;
        ++this.count;
    }

    private int getColor() {
        if (this.alpha == 0 || this.count == 0) {
            return 0;
        }
        int ca = this.alpha / this.count & 0xFF;
        int cr = this.red / this.alpha & 0xFF;
        int cg = this.green / this.alpha & 0xFF;
        int cb = this.blue / this.alpha & 0xFF;
        return ca << 24 | cr << 16 | cg << 8 | cb;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int light) {
        if (this.count == 0) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        FluidRenderer.renderWaterBox(0.125f, 0.0625f, 0.125f, 0.875f, 0.08125f, 0.875f, buffer, poseStack, light, this.getColor());
        poseStack.m_85849_();
    }
}

