/*
 * Decompiled with CFR 0.152.
 */
package com.wolf.petconnect;

import com.mojang.brigadier.CommandDispatcher;
import com.wolf.petconnect.HadGoety;
import com.wolf.petconnect.ModMessages;
import com.wolf.petconnect.PetConnect;
import com.wolf.petconnect.PetConnectMessage;
import com.wolf.petconnect.config.ConfigCommon;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="petconnect", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PetConnectEventHandler {
    public static int havePetsNumber = 0;
    public static final ResourceKey<Level> MY_CUSTOM_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("petconnect:petconnect"));

    public static List<LivingEntity> findTamedPets(Player player, double range, BlockPos blockPos) {
        Level level = player.m_9236_();
        AABB searchArea = new AABB(blockPos).m_82400_(range);
        ArrayList<TamableAnimal> livingEntities = new ArrayList<TamableAnimal>(level.m_45976_(TamableAnimal.class, searchArea).stream().filter(tamable -> tamable.m_21824_() && Objects.equals(tamable.m_21805_(), player.m_20148_())).toList());
        if (ModList.get().isLoaded("goety")) {
            HadGoety.hadGoety(livingEntities, (ServerLevel)level, searchArea, player);
        }
        return livingEntities;
    }

    public static List<LivingEntity> findTamedPets1(Player player, double range) {
        ServerLevel targetWorld = Objects.requireNonNull(player.m_20194_()).m_129880_(MY_CUSTOM_DIMENSION);
        BlockPos blockPos = new BlockPos(0, -510, 0);
        AABB searchArea = new AABB(blockPos).m_82400_(range);
        ArrayList<TamableAnimal> livingEntity = new ArrayList<TamableAnimal>(targetWorld.m_45976_(TamableAnimal.class, searchArea).stream().filter(tamable -> tamable.m_21824_() && tamable.m_21805_().equals(player.m_20148_())).toList());
        if (ModList.get().isLoaded("goety")) {
            HadGoety.hadGoety(livingEntity, targetWorld, searchArea, player);
        }
        return livingEntity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public static void rightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_21205_().m_150930_((Item)PetConnect.PET_CONNECT.get())) {
                ItemStack itemstack = player.m_21205_();
                List<LivingEntity> tamedPets = PetConnectEventHandler.findTamedPets((Player)serverPlayer, (Double)ConfigCommon.CONNECT_DISTANCE.get(), serverPlayer.m_20183_());
                List<LivingEntity> existingPetsInTargetWorld = PetConnectEventHandler.findTamedPets1((Player)serverPlayer, 10.0);
                int petLimit = (Integer)ConfigCommon.LIMIT_PETS_NUMBER.get();
                if (!tamedPets.isEmpty()) {
                    int remainingSlots = petLimit - existingPetsInTargetWorld.size();
                    if (remainingSlots > 0) {
                        for (LivingEntity pet : tamedPets) {
                            if (remainingSlots <= 0) {
                                player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc3").m_130940_(ChatFormatting.RED), true);
                                break;
                            }
                            pet.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, pet.m_20185_(), pet.m_20186_(), pet.m_20189_(), 1.0, 1.0, 1.0);
                            if (!(pet.m_9236_() instanceof ServerLevel)) continue;
                            ServerLevel targetWorld = player.m_20194_().m_129880_(MY_CUSTOM_DIMENSION);
                            if (targetWorld != null) {
                                try {
                                    float health = pet.m_21223_();
                                    float yaw = player.m_146908_();
                                    float pitch = player.m_146909_();
                                    EnumSet<RelativeMovement> relativeMovements = EnumSet.noneOf(RelativeMovement.class);
                                    pet.m_20242_(true);
                                    CompoundTag tag = pet.m_20240_(new CompoundTag());
                                    tag.m_128379_("NoAI", true);
                                    pet.m_20258_(tag);
                                    CommandDispatcher dispatcher = serverPlayer.m_20194_().m_129892_().m_82094_();
                                    CommandSourceStack source = serverPlayer.m_20194_().m_129893_();
                                    dispatcher.execute("execute in " + player.m_9236_().m_46472_().m_135782_() + " run particle minecraft:portal " + pet.m_146903_() + " " + pet.m_146904_() + " " + pet.m_146907_() + " 0.12 0.3 0.12 0.2 80 force", (Object)source);
                                    pet.m_264318_(targetWorld, 0.0, -510.0, 0.0, relativeMovements, yaw, pitch);
                                    pet.m_21153_(health);
                                    player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc").m_130940_(ChatFormatting.GREEN), true);
                                    --remainingSlots;
                                    ++havePetsNumber;
                                    if (itemstack.m_41783_() != null && itemstack.m_41783_().m_128441_("havePetsNumber")) {
                                        itemstack.m_41784_().m_128405_("havePetsNumber", 1 + itemstack.m_41783_().m_128451_("havePetsNumber"));
                                        continue;
                                    }
                                    itemstack.m_41784_().m_128405_("havePetsNumber", 1);
                                }
                                catch (Exception e) {
                                    player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc1").m_130940_(ChatFormatting.DARK_RED), true);
                                }
                                continue;
                            }
                            player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc2").m_130940_(ChatFormatting.DARK_RED), true);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc4").m_130940_(ChatFormatting.RED), true);
                    }
                    event.setCanceled(true);
                    return;
                }
                player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc5").m_130940_(ChatFormatting.RED), true);
                return;
            }
        }
        if (!(player instanceof ServerPlayer)) return;
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!player.m_21205_().m_150930_((Item)PetConnect.PET_CONNECT1.get())) return;
        ItemStack heldItem = player.m_21205_();
        List<LivingEntity> tamedPets = PetConnectEventHandler.findTamedPets1((Player)serverPlayer, 10.0);
        if (!tamedPets.isEmpty()) {
            for (LivingEntity pet : tamedPets) {
                if (!(pet.m_9236_() instanceof ServerLevel)) continue;
                ServerLevel targetWorld = player.m_20194_().m_129880_(MY_CUSTOM_DIMENSION);
                if (targetWorld != null) {
                    try {
                        float health = pet.m_21223_();
                        float yaw = player.m_146908_();
                        float pitch = player.m_146909_();
                        EnumSet<RelativeMovement> relativeMovements = EnumSet.noneOf(RelativeMovement.class);
                        pet.m_20242_(false);
                        CompoundTag tag = pet.m_20240_(new CompoundTag());
                        tag.m_128379_("NoAI", false);
                        pet.m_20258_(tag);
                        pet.m_264318_(((ServerPlayer)player).m_284548_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), relativeMovements, yaw, pitch);
                        pet.m_21153_(health);
                        player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc6").m_130940_(ChatFormatting.GREEN), true);
                        havePetsNumber = 0;
                        if (heldItem.m_41783_() == null || !heldItem.m_41783_().m_128441_("havePetsNumber")) continue;
                        heldItem.m_41749_("havePetsNumber");
                    }
                    catch (Exception e) {
                        player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc1").m_130940_(ChatFormatting.DARK_RED), true);
                    }
                    continue;
                }
                player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc2").m_130940_(ChatFormatting.DARK_RED), true);
            }
            event.setCanceled(true);
            return;
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc7").m_130940_(ChatFormatting.DARK_RED), true);
        }
    }

    @SubscribeEvent
    public static void onPetInPetWorld(LivingHurtEvent event) {
        ServerLevel targetWorld = event.getEntity().m_20194_().m_129880_(MY_CUSTOM_DIMENSION);
        if (event.getEntity().m_9236_() == targetWorld) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(TickEvent.PlayerTickEvent event) {
        if (((KeyMapping)PetConnect.ClientInit.EXAMPLE_MAPPING.get()).m_90859_()) {
            Player player = event.player;
            if (player.m_21205_().m_150930_((Item)PetConnect.PET_CONNECT.get())) {
                player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc9").m_130940_(ChatFormatting.GOLD), true);
                ModMessages.INSTANCE.sendToServer((Object)new PetConnectMessage(player.m_150109_().f_35977_, new ItemStack((ItemLike)PetConnect.PET_CONNECT1.get())));
            } else if (player.m_21205_().m_150930_((Item)PetConnect.PET_CONNECT1.get())) {
                player.m_5661_((Component)Component.m_237115_((String)"item.petconnect.pet_connect.desc8").m_130940_(ChatFormatting.GOLD), true);
                ModMessages.INSTANCE.sendToServer((Object)new PetConnectMessage(player.m_150109_().f_35977_, new ItemStack((ItemLike)PetConnect.PET_CONNECT.get())));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ChunkPos chunkPos = new ChunkPos(0, 0);
        ServerLevel serverLevel = event.getEntity().m_20194_().m_129880_(MY_CUSTOM_DIMENSION);
        serverLevel.m_7726_().m_8387_(TicketType.f_9445_, chunkPos, 0, (Object)chunkPos);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)PetConnect.ClientInit.EXAMPLE_MAPPING.get());
    }
}

