/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.v1.youkaishomecoming;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.maidsoulkitchen.entity.passive.IAddonMaid;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.RegisterData;
import com.github.wallev.maidsoulkitchen.mixin.youkaishomecoming.KettleBlockAccessor;
import com.github.wallev.maidsoulkitchen.task.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.maidsoulkitchen.task.cook.v1.common.TaskFdPot;
import com.github.wallev.maidsoulkitchen.util.FakePlayerUtil;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.content.pot.kettle.KettleBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.kettle.KettleRecipe;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TaskYhcTeaKettle
extends TaskFdPot<KettleBlockEntity, KettleRecipe> {
    @Override
    public ItemStackHandler getItemStackHandler(KettleBlockEntity be) {
        return be.getInventory();
    }

    @Override
    public int getOutputSlot() {
        return 6;
    }

    @Override
    public int getInputSize() {
        return 4;
    }

    @Override
    public ItemStackHandler getBeInv(KettleBlockEntity kettleBlockEntity) {
        return kettleBlockEntity.getInventory();
    }

    @Override
    public int getMealStackSlot() {
        return 4;
    }

    @Override
    public int getContainerStackSlot() {
        return 5;
    }

    @Override
    public ItemStack getFoodContainer(KettleBlockEntity blockEntity) {
        return blockEntity.getContainer();
    }

    @Override
    public boolean isHeated(KettleBlockEntity be) {
        return be.isHeated();
    }

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof KettleBlockEntity;
    }

    @Override
    public RecipeType<KettleRecipe> getRecipeType() {
        return (RecipeType)YHBlocks.KETTLE_RT.get();
    }

    public ResourceLocation getUid() {
        return TaskInfo.YHC_TEA_KETTLE.uid;
    }

    public ItemStack getIcon() {
        return YHBlocks.KETTLE.asStack();
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.YHC_TEA_KETTLE;
    }

    @Override
    public boolean canCook(KettleBlockEntity be, KettleRecipe recipe) {
        return super.canCook((BlockEntity)be, (Recipe)recipe) && be.getWater() > 0;
    }

    @Override
    public boolean shouldMoveTo(ServerLevel level, EntityMaid maid, KettleBlockEntity be, MaidRecipesManager<KettleRecipe> manager) {
        return super.shouldMoveTo(level, maid, be, manager);
    }

    @Override
    public void processCookMake(ServerLevel level, EntityMaid maid, KettleBlockEntity be, MaidRecipesManager<KettleRecipe> manager) {
        super.processCookMake(level, maid, be, manager);
    }

    @Override
    public void tryInsertItem(ServerLevel serverLevel, EntityMaid entityMaid, KettleBlockEntity blockEntity, MaidRecipesManager<KettleRecipe> maidRecipesManager) {
        if (this.needWater(blockEntity)) {
            return;
        }
        super.tryInsertItem(serverLevel, entityMaid, (BlockEntity)blockEntity, maidRecipesManager);
    }

    @Override
    public boolean maidShouldMoveTo(ServerLevel level, EntityMaid maid, KettleBlockEntity kettleBlockEntity, MaidRecipesManager<KettleRecipe> manager) {
        ItemStackHandler inventory = this.getItemStackHandler(kettleBlockEntity);
        ItemStack outputStack = inventory.getStackInSlot(this.getOutputSlot());
        if (!outputStack.m_41619_()) {
            return true;
        }
        ItemStack mealStack = this.getBeInvMealStack((BlockEntity)kettleBlockEntity, inventory);
        ItemStack container = this.getFoodContainer(kettleBlockEntity);
        boolean hasOutputAdditionItem = manager.hasOutputAdditionItem(container);
        if (!mealStack.m_41619_() && hasOutputAdditionItem) {
            return true;
        }
        boolean heated = this.isHeated(kettleBlockEntity);
        Optional recipe = this.getMatchingRecipe((BlockEntity)kettleBlockEntity, new RecipeWrapper((IItemHandlerModifiable)inventory));
        boolean b = recipe.isPresent() && this.canCook(kettleBlockEntity, (KettleRecipe)recipe.get());
        List<Pair<List<Integer>, List<List<ItemStack>>>> recipesIngredients = manager.getRecipesIngredients();
        if (!(b || recipesIngredients.isEmpty() || !heated || this.needWater(kettleBlockEntity) && this.findMaidHasWaterResource(maid, kettleBlockEntity) == -1 || !mealStack.m_41619_())) {
            return true;
        }
        if (!b && this.hasInput(inventory)) {
            return true;
        }
        ItemStack containerInputStack = inventory.getStackInSlot(this.getContainerStackSlot());
        return !this.hasInput(inventory) && !containerInputStack.m_41619_();
    }

    public boolean needWater(KettleBlockEntity kettleBlockEntity) {
        return kettleBlockEntity.getWater() <= 200;
    }

    @Override
    public void tryExtractItem(ServerLevel serverLevel, EntityMaid entityMaid, KettleBlockEntity blockEntity, MaidRecipesManager<KettleRecipe> maidRecipesManager) {
        this.replenishWater(entityMaid, blockEntity);
        super.tryExtractItem(serverLevel, entityMaid, (BlockEntity)blockEntity, maidRecipesManager);
    }

    private boolean replenishWater(EntityMaid entityMaid, KettleBlockEntity blockEntity) {
        int stackSlot;
        if (this.needWater(blockEntity) && (stackSlot = this.findMaidHasWaterResource(entityMaid, blockEntity)) != -1) {
            ItemStack waterStack = entityMaid.getAvailableInv(true).getStackInSlot(stackSlot);
            WeakReference<FakePlayer> fakePlayer$tlma = ((IAddonMaid)entityMaid).tlmk$getFakePlayer();
            FakePlayer fakePlayer = (FakePlayer)fakePlayer$tlma.get();
            if (fakePlayer != null) {
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, waterStack.m_41620_(1));
                try {
                    InteractionResult interactionResult = FakePlayerUtil.interactUseOnBlock(fakePlayer$tlma, entityMaid.m_9236_(), blockEntity.m_58899_(), InteractionHand.MAIN_HAND, null);
                    if (interactionResult != InteractionResult.PASS) {
                        ItemStack itemInHand = fakePlayer.m_21120_(InteractionHand.MAIN_HAND);
                        ItemHandlerHelper.insertItemStacked((IItemHandler)entityMaid.getAvailableInv(true), (ItemStack)itemInHand.m_41777_(), (boolean)false);
                        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    } else {
                        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    }
                    if (interactionResult == InteractionResult.PASS) {
                        BlockState blockState = entityMaid.f_19853_.m_8055_(blockEntity.m_58899_());
                        Block block = blockState.m_60734_();
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    public List<ItemStack> getWaterSourceList(KettleBlockEntity kettleBlockEntity) {
        Block block = kettleBlockEntity.m_58900_().m_60734_();
        Lazy<Map<Ingredient, Integer>> waterMAP = ((KettleBlockAccessor)block).getMAP();
        Set ingredients = ((Map)waterMAP.get()).keySet();
        List<ItemStack> list = ingredients.stream().map(Ingredient::m_43908_).flatMap(Stream::of).toList();
        return list;
    }

    public int findMaidHasWaterResource(EntityMaid entityMaid, KettleBlockEntity kettleBlockEntity) {
        List<ItemStack> waterSourceList = this.getWaterSourceList(kettleBlockEntity);
        CombinedInvWrapper availableInv = entityMaid.getAvailableInv(true);
        int stackSlot = ItemsUtil.findStackSlot((IItemHandler)availableInv, itemStack -> waterSourceList.stream().anyMatch(ingredient -> ingredient.m_150930_(itemStack.m_41720_())));
        return stackSlot;
    }
}

