/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.wallev.maidsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.init.MkEntities;
import com.github.wallev.maidsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class MaidCookMakeTask<B extends BlockEntity, R extends Recipe<? extends Container>>
extends Behavior<EntityMaid> {
    private final ICookTask<B, R> task;
    private final MaidRecipesManager<R> maidRecipesManager;

    public MaidCookMakeTask(ICookTask<B, R> task, MaidRecipesManager<R> maidRecipesManager) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT));
        this.task = task;
        this.maidRecipesManager = maidRecipesManager;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        Brain brain = maid.m_6274_();
        return brain.m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            Vec3 targetV3d = targetPos.m_7024_();
            if (maid.m_20238_(targetV3d) > Math.pow(this.task.getCloseEnoughDist(), 2.0)) {
                Optional walkTarget = brain.m_21952_(MemoryModuleType.f_26370_);
                if (walkTarget.isEmpty() || !((WalkTarget)walkTarget.get()).m_26420_().m_7024_().equals((Object)targetV3d)) {
                    brain.m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                    brain.m_21936_((MemoryModuleType)MkEntities.WORK_POS.get());
                }
                return false;
            }
            return true;
        }).orElse(false);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        if (maid != this.maidRecipesManager.getMaid()) {
            return;
        }
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockPos basePos = posWrapper.m_6675_();
            BlockEntity blockEntity = worldIn.m_7702_(basePos);
            if (blockEntity != null && this.task.isCookBE(blockEntity)) {
                this.task.processCookMake(worldIn, maid, blockEntity, this.maidRecipesManager);
                this.maidRecipesManager.getCookInv().syncInv();
                this.maidRecipesManager.tranOutput2Chest();
                this.maidRecipesManager.getCookInv().syncInv();
            }
            maid.m_6274_().m_21936_((MemoryModuleType)MkEntities.WORK_POS.get());
            maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
            maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        });
    }
}

