/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.api.task.v1.cook;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.github.wallev.maidsoulkitchen.api.IMaidsoulKitchenTask;
import com.github.wallev.maidsoulkitchen.api.TaskBookEntryType;
import com.github.wallev.maidsoulkitchen.api.event.MaidMkTaskEnableEvent;
import com.github.wallev.maidsoulkitchen.api.task.IDataTask;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.maidsoulkitchen.inventory.container.maid.CookConfigContainer;
import com.github.wallev.maidsoulkitchen.inventory.tooltip.AmountTooltip;
import com.github.wallev.maidsoulkitchen.task.ai.MaidCookMakeTask;
import com.github.wallev.maidsoulkitchen.task.ai.MaidCookMoveTask;
import com.github.wallev.maidsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public interface ICookTask<B extends BlockEntity, R extends Recipe<? extends Container>>
extends IMaidsoulKitchenTask,
IDataTask<CookData> {
    default public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Collections.emptyList();
        }
        MaidRecipesManager<R> cookingPotRecipeMaidRecipesManager = this.getRecipesManager(maid);
        MaidCookMoveTask maidCookMoveTask = new MaidCookMoveTask(this, cookingPotRecipeMaidRecipesManager);
        MaidCookMakeTask maidCookMakeTask = new MaidCookMakeTask(this, cookingPotRecipeMaidRecipesManager);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, maidCookMoveTask), Pair.of((Object)6, maidCookMakeTask)});
    }

    default public MaidRecipesManager<R> getRecipesManager(EntityMaid maid) {
        return new MaidRecipesManager(maid, this, false);
    }

    default public List<R> getRecipes(Level level) {
        return level.m_7465_().m_44013_(this.getRecipeType());
    }

    @Nullable
    default public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound((EntityMaid)maid, (SoundEvent)((SoundEvent)InitSounds.MAID_FURNACE.get()), (float)0.5f);
    }

    default public double getCloseEnoughDist() {
        return 3.2;
    }

    @Override
    default public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        MaidMkTaskEnableEvent maidMkTaskEnableEvent = new MaidMkTaskEnableEvent(maid, this);
        MinecraftForge.EVENT_BUS.post((Event)maidMkTaskEnableEvent);
        if (!maidMkTaskEnableEvent.isEnable()) {
            return maidMkTaskEnableEvent.getEnableConditionDesc();
        }
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"has_enough_favor", this::hasEnoughFavor)});
    }

    @Override
    default public boolean isEnable(EntityMaid maid) {
        MaidMkTaskEnableEvent maidMkTaskEnableEvent = new MaidMkTaskEnableEvent(maid, this);
        MinecraftForge.EVENT_BUS.post((Event)maidMkTaskEnableEvent);
        if (!maidMkTaskEnableEvent.isEnable()) {
            return false;
        }
        return this.hasEnoughFavor(maid);
    }

    default public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Cook Config Container2");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory playerInventory, Player player) {
                return new CookConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    default public boolean hasEnoughFavor(EntityMaid maid) {
        return maid.getFavorabilityManager().getLevel() >= 1;
    }

    public boolean isCookBE(BlockEntity var1);

    public RecipeType<R> getRecipeType();

    public boolean shouldMoveTo(ServerLevel var1, EntityMaid var2, B var3, MaidRecipesManager<R> var4);

    public void processCookMake(ServerLevel var1, EntityMaid var2, B var3, MaidRecipesManager<R> var4);

    @Override
    default public TaskBookEntryType getBookEntryType() {
        return TaskBookEntryType.COOK;
    }

    @Override
    default public CookData getDefaultData() {
        return new CookData();
    }

    default public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        return recipe.m_7527_();
    }

    default public ItemStack getResultItem(Recipe<?> recipe, RegistryAccess pRegistryAccess) {
        return recipe.m_8043_(pRegistryAccess);
    }

    default public Optional<TooltipComponent> getRecClientAmountTooltip(Recipe<?> recipe, boolean modeRandom, boolean overSize) {
        NonNullList<Ingredient> ingres = this.getIngredients(recipe);
        return ingres.isEmpty() ? Optional.empty() : Optional.of(new AmountTooltip((List<Ingredient>)ingres, modeRandom, overSize));
    }

    default public List<Component> getWarnComponent() {
        return Collections.emptyList();
    }
}

