/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.xkmc.l2library.init.data.L2TagGen;
import dev.xkmc.l2serial.serialization.codec.JsonCodec;
import dev.xkmc.l2serial.serialization.codec.PacketCodec;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class AbstractSmithingRecipe<T extends AbstractSmithingRecipe<T>>
extends SmithingTransformRecipe {
    public static final Ingredient TEMPLATE_PLACEHOLDER = Ingredient.m_204132_(L2TagGen.SMITHING_TEMPLATE);

    public AbstractSmithingRecipe(ResourceLocation rl, Ingredient left, Ingredient right, ItemStack result) {
        super(rl, TEMPLATE_PLACEHOLDER, left, right, result);
    }

    public AbstractSmithingRecipe(ResourceLocation rl, Ingredient template, Ingredient left, Ingredient right, ItemStack result) {
        super(rl, template, left, right, result);
    }

    public abstract Serializer<T> getSerializer();

    public static class Serializer<T extends AbstractSmithingRecipe<T>>
    extends SmithingTransformRecipe.Serializer {
        private final RecipeFactoryWithTemplate<T> factory;

        public Serializer(RecipeFactory<T> factory) {
            this.factory = factory::create;
        }

        public Serializer(RecipeFactoryWithTemplate<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject obj) {
            SmithingTransformRecipe r = super.m_6729_(id, obj);
            return this.factory.create(r.m_6423_(), r.f_265949_, r.f_265888_, r.f_265907_, r.f_266098_);
        }

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf obj) {
            SmithingTransformRecipe r = super.m_8005_(id, obj);
            if (r == null) {
                return null;
            }
            return this.factory.create(r.m_6423_(), r.f_265949_, r.f_265888_, r.f_265907_, r.f_266098_);
        }

        public void toJson(T recipe, JsonObject obj) {
        }
    }

    public static class SerialSerializer<T extends AbstractSmithingRecipe<T>>
    extends Serializer<T> {
        private final Class<T> cls;

        public SerialSerializer(Class<T> cls, RecipeFactory<T> factory) {
            super(factory);
            this.cls = cls;
        }

        public SerialSerializer(Class<T> cls, RecipeFactoryWithTemplate<T> factory) {
            super(factory);
            this.cls = cls;
        }

        @Override
        public T fromJson(ResourceLocation id, JsonObject obj) {
            return (T)((Object)Objects.requireNonNull((AbstractSmithingRecipe)((Object)JsonCodec.from((JsonElement)obj, this.cls, super.fromJson(id, obj)))));
        }

        public void m_6178_(FriendlyByteBuf buf, SmithingTransformRecipe rec) {
            super.m_6178_(buf, rec);
            PacketCodec.to((FriendlyByteBuf)buf, (Object)rec);
        }

        @Override
        public T fromNetwork(ResourceLocation id, FriendlyByteBuf obj) {
            return (T)((Object)((AbstractSmithingRecipe)((Object)PacketCodec.from((FriendlyByteBuf)obj, this.cls, super.fromNetwork(id, obj)))));
        }

        @Override
        public void toJson(T recipe, JsonObject obj) {
            JsonCodec.toJsonObject(recipe, (JsonObject)obj);
        }
    }

    @FunctionalInterface
    public static interface RecipeFactoryWithTemplate<T extends AbstractSmithingRecipe<T>> {
        public T create(ResourceLocation var1, Ingredient var2, Ingredient var3, Ingredient var4, ItemStack var5);
    }

    @FunctionalInterface
    public static interface RecipeFactory<T extends AbstractSmithingRecipe<T>> {
        public T create(ResourceLocation var1, Ingredient var2, Ingredient var3, ItemStack var4);

        default public T create(ResourceLocation rl, Ingredient template, Ingredient left, Ingredient right, ItemStack result) {
            return this.create(rl, left, right, result);
        }
    }
}

