/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.advancements;

import com.tterrag.registrate.providers.RegistrateAdvancementProvider;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.compat.patchouli.PatchouliHelper;
import dev.xkmc.l2library.serial.advancements.AdvProviderWrapper;
import dev.xkmc.l2library.serial.advancements.CriterionBuilder;
import dev.xkmc.l2library.serial.advancements.IAdvBuilder;
import dev.xkmc.l2library.serial.advancements.ModLoadedAdv;
import dev.xkmc.l2library.serial.advancements.RewardBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AdvancementGenerator {
    private final RegistrateAdvancementProvider pvd;
    private final String modid;

    public AdvancementGenerator(RegistrateAdvancementProvider pvd, String modid) {
        this.pvd = pvd;
        this.modid = modid;
    }

    private record EntryData(String id, ItemStack item, List<IAdvBuilder> builder, String title, String desc) {
        EntryData(String id, ItemStack item, IAdvBuilder builder, String title, String desc) {
            this(id, item, new ArrayList<IAdvBuilder>(List.of(builder)), title, desc);
        }
    }

    public class TabBuilder {
        private final String tab;
        private final ResourceLocation bg;
        private Entry root;

        public TabBuilder(String tab) {
            this.tab = tab;
            this.bg = new ResourceLocation(AdvancementGenerator.this.modid, "textures/gui/advancements/backgrounds/" + tab + ".png");
        }

        public void build() {
            this.root.build();
        }

        public Entry root(String id, Item item, CriterionBuilder builder, String title, String desc) {
            return this.root(id, item.m_7968_(), builder, title, desc);
        }

        public Entry root(String id, ItemStack item, CriterionBuilder builder, String title, String desc) {
            if (this.root == null) {
                this.root = new Entry(new EntryData(id, item, builder, title, desc), null);
            }
            return this.root;
        }

        public Entry hidden(String id, CriterionBuilder builder) {
            return new Entry(new EntryData(id, ItemStack.f_41583_, builder, "", ""), null);
        }

        public class Entry {
            private final List<Entry> children = new ArrayList<Entry>();
            private final EntryData data;
            private final ResourceLocation rl;
            private final Entry parent;
            private FrameType type = FrameType.TASK;
            private boolean showToast = true;
            private boolean announce = true;
            private boolean hidden = false;
            private Advancement result;

            private Entry(@Nullable EntryData data, Entry parent) {
                this.data = data;
                this.parent = parent;
                if (parent == null) {
                    this.showToast = false;
                    this.announce = false;
                    this.rl = TabBuilder.this.bg;
                } else {
                    this.rl = null;
                }
            }

            public Entry create(String id, Item item, CriterionBuilder builder, String title, String desc) {
                return this.create(id, item.m_7968_(), builder, title, desc);
            }

            public Entry create(String id, ItemStack item, CriterionBuilder builder, String title, String desc) {
                Entry sub = new Entry(new EntryData(id, item, builder, title, desc), this);
                this.children.add(sub);
                return sub;
            }

            public Entry patchouli(L2Registrate reg, CriterionBuilder builder, ResourceLocation book, String title, String desc) {
                ItemStack stack = PatchouliHelper.getBook(book);
                return this.create("patchouli", stack, builder, title, desc).add(new ModLoadedAdv("patchouli")).add(new RewardBuilder(reg, 0, book, () -> PatchouliHelper.getBookLoot(book)));
            }

            public Entry root() {
                return TabBuilder.this.root;
            }

            public Entry enter() {
                return this.children.get(this.children.size() - 1);
            }

            public Entry type(FrameType type) {
                this.type = type;
                return this;
            }

            public Entry type(FrameType type, boolean showToast, boolean announce, boolean hidden) {
                this.type = type;
                this.showToast = showToast;
                this.announce = announce;
                this.hidden = hidden;
                return this;
            }

            public Entry add(IAdvBuilder builder) {
                this.data.builder.add(builder);
                return this;
            }

            public void build() {
                Advancement.Builder builder = Advancement.Builder.m_138353_();
                if (!this.data.item.m_41619_()) {
                    builder.m_138362_(this.data.item, (Component)AdvancementGenerator.this.pvd.title(AdvancementGenerator.this.modid, "advancements." + TabBuilder.this.tab + "." + this.data.id, this.data.title), (Component)AdvancementGenerator.this.pvd.desc(AdvancementGenerator.this.modid, "advancements." + TabBuilder.this.tab + "." + this.data.id, this.data.desc), this.rl, this.type, this.showToast, this.announce, this.hidden);
                }
                if (this.parent != null) {
                    builder.m_138398_(this.parent.result);
                }
                String uid = AdvancementGenerator.this.modid + ":" + TabBuilder.this.tab + "/" + this.data.id;
                for (IAdvBuilder iAdvBuilder : this.data.builder) {
                    iAdvBuilder.modify(uid, builder);
                    iAdvBuilder.onBuild();
                }
                this.result = builder.m_138389_(r -> AdvProviderWrapper.save(AdvancementGenerator.this.pvd, this.data.builder, r), uid);
                for (Entry entry : this.children) {
                    entry.build();
                }
            }

            public void finish() {
                TabBuilder.this.build();
            }
        }
    }
}

