/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.recipe;

import dev.xkmc.l2library.serial.recipe.AbstractShapedRecipe;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.registrate.GolemMiscs;
import java.util.ArrayList;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class GolemReplaceRecipe
extends AbstractShapedRecipe<GolemReplaceRecipe> {
    public GolemReplaceRecipe(ResourceLocation rl, String group, int w, int h, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(rl, group, w, h, ingredients, result);
    }

    public boolean m_5818_(CraftingContainer cont, Level level) {
        if (!super.m_5818_(cont, level)) {
            return false;
        }
        for (int i = 0; i < cont.m_6643_(); ++i) {
            ItemStack input = cont.m_8020_(i);
            if (input.m_41619_() || !(input.m_41720_() instanceof GolemPart) || !GolemPart.getMaterial(input).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(CraftingContainer cont, RegistryAccess access) {
        boolean holderFirst = false;
        ItemStack holder = null;
        ResourceLocation mat = null;
        IGolemPart[] parts = null;
        IGolemPart<?> sel = null;
        for (int i = 0; i < cont.m_6643_(); ++i) {
            ItemStack input = cont.m_8020_(i);
            if (input.m_41619_()) continue;
            Item item = input.m_41720_();
            if (item instanceof GolemHolder) {
                GolemHolder h = (GolemHolder)item;
                holder = input;
                parts = h.getEntityType().values();
                if (sel == null) {
                    holderFirst = true;
                }
            }
            if (!((item = input.m_41720_()) instanceof GolemPart)) continue;
            GolemPart p = (GolemPart)item;
            mat = GolemPart.getMaterial(input).orElse(null);
            sel = (IGolemPart<?>)p.getPart();
        }
        return this.replacePart(holder, mat, parts, sel, holderFirst);
    }

    public ItemStack assembleForJEI(ResourceLocation mat) {
        boolean holderFirst = false;
        ItemStack holder = null;
        IGolemPart[] parts = null;
        IGolemPart<?> sel = null;
        for (Ingredient ing : this.m_7527_()) {
            ItemStack input;
            if (ing.m_43947_() || ing.m_43908_().length != 1 || (input = ing.m_43908_()[0]).m_41619_()) continue;
            Item item = input.m_41720_();
            if (item instanceof GolemHolder) {
                GolemHolder h = (GolemHolder)item;
                holder = input;
                parts = h.getEntityType().values();
                if (sel == null) {
                    holderFirst = true;
                }
            }
            if (!((item = input.m_41720_()) instanceof GolemPart)) continue;
            GolemPart p = (GolemPart)item;
            sel = (IGolemPart<?>)p.getPart();
        }
        return this.replacePart(holder, mat, parts, sel, holderFirst);
    }

    @ParametersAreNullableByDefault
    public ItemStack replacePart(ItemStack holder, ResourceLocation mat, IGolemPart<?>[] parts, IGolemPart<?> sel, boolean holderFirst) {
        if (holder == null || parts == null || mat == null || sel == null) {
            return ItemStack.f_41583_;
        }
        int index = -1;
        if (!holderFirst) {
            for (i = 0; i < parts.length; ++i) {
                if (parts[i].toItem() != sel.toItem()) continue;
                index = i;
                break;
            }
        } else {
            for (i = parts.length - 1; i >= 0; --i) {
                if (parts[i].toItem() != sel.toItem()) continue;
                index = i;
                break;
            }
        }
        if (index < 0) {
            return ItemStack.f_41583_;
        }
        ItemStack result = holder.m_41777_();
        ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(result);
        if (mats.size() < parts.length) {
            result = holder.m_41720_().m_7968_();
            mats.clear();
            for (IGolemPart<?> e : parts) {
                GolemHolder.addMaterial(result, e.toItem(), ModularGolems.loc("empty"));
            }
        }
        GolemHolder.setMaterial(result, index, mat);
        return result;
    }

    public AbstractShapedRecipe.Serializer<GolemReplaceRecipe> getSerializer() {
        return (AbstractShapedRecipe.Serializer)GolemMiscs.REPLACE.get();
    }
}

