/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.metalgolem;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.client.armor.GolemEquipmentModels;
import dev.xkmc.modulargolems.content.client.armor.GolemModelPath;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemModel;
import dev.xkmc.modulargolems.content.item.equipments.GolemModelItem;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemBeaconItem;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class GolemEquipmentRenderer
extends RenderLayer<MetalGolemEntity, MetalGolemModel> {
    public HashMap<ModelLayerLocation, MetalGolemModel> map = new HashMap();
    final ResourceLocation BEACON_LOCATION = new ResourceLocation("modulargolems", "textures/equipments/beacon.png");
    final ResourceLocation BEAM_LOCATION = new ResourceLocation("textures/entity/beacon_beam.png");

    public GolemEquipmentRenderer(RenderLayerParent<MetalGolemEntity, MetalGolemModel> r, EntityRendererProvider.Context e) {
        super(r);
        for (ModelLayerLocation l : GolemEquipmentModels.LIST) {
            this.map.put(l, new MetalGolemModel(e.m_174023_(l)));
        }
    }

    public void render(@NotNull PoseStack pose, MultiBufferSource source, int i, @NotNull MetalGolemEntity entity, float f1, float f2, float f3, float f4, float f5, float f6) {
        for (EquipmentSlot e : EquipmentSlot.values()) {
            Item buffer;
            ItemStack stack = entity.m_6844_(e);
            Item item = stack.m_41720_();
            if (item instanceof GolemModelItem) {
                GolemModelItem mgaitem = (GolemModelItem)item;
                buffer = source.m_6299_(RenderType.m_110431_((ResourceLocation)mgaitem.getModelTexture()));
                this.renderArmor(mgaitem, pose, (VertexConsumer)buffer, i);
                if (!mgaitem.emissive()) continue;
                buffer = source.m_6299_(RenderType.m_110431_((ResourceLocation)mgaitem.getEmissiveModelTexture()));
                this.renderArmor(mgaitem, pose, (VertexConsumer)buffer, 0xF000F0);
                continue;
            }
            buffer = stack.m_41720_();
            if (buffer instanceof MetalGolemBeaconItem) {
                MetalGolemBeaconItem beacon = (MetalGolemBeaconItem)buffer;
                if (!entity.isAddedToWorld()) {
                    return;
                }
                float[] color = new float[]{1.0f, 1.0f, 1.0f};
                this.renderBeacon(pose, source, i, entity.m_9236_().m_46467_(), entity.m_20206_());
                this.renderBeam(pose, source, i, 1.0f, entity.m_9236_().m_46467_(), entity.m_20206_(), color);
                continue;
            }
            this.renderArmWithItem(entity, stack, e, pose, source, i);
        }
    }

    protected void renderArmor(GolemModelItem mgaitem, PoseStack pose, VertexConsumer buffer, int light) {
        GolemModelPath gmpath = GolemModelPath.get(mgaitem.getModelPath());
        for (List<String> ls : gmpath.paths()) {
            MetalGolemModel model = this.map.get(gmpath.models());
            model.copyFrom((MetalGolemModel)this.m_117386_());
            ModelPart gemr = model.m_142109_();
            pose.m_85836_();
            for (String s : ls) {
                gemr.m_104299_(pose);
                gemr = gemr.m_171324_(s);
            }
            gemr.m_104306_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            pose.m_85849_();
        }
    }

    protected void renderArmWithItem(MetalGolemEntity entity, ItemStack stack, EquipmentSlot slot, PoseStack pose, MultiBufferSource source, int light) {
        if (stack.m_41619_()) {
            return;
        }
        ItemDisplayContext ctx = null;
        if (slot == EquipmentSlot.MAINHAND) {
            ctx = ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        } else if (slot == EquipmentSlot.OFFHAND) {
            ctx = ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        }
        if (ctx == null) {
            return;
        }
        pose.m_85836_();
        ((MetalGolemModel)this.m_117386_()).transformToHand(slot, pose);
        boolean offhand = slot == EquipmentSlot.OFFHAND;
        pose.m_252880_((float)(offhand ? 1 : -1) * 0.7f, 0.8f, -0.25f);
        pose.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        Minecraft.m_91087_().m_91291_().m_269491_((LivingEntity)entity, stack, ctx, offhand, pose, source, entity.m_9236_(), light, OverlayTexture.f_118083_, entity.m_19879_() + slot.ordinal());
        pose.m_85849_();
    }

    protected void renderBeacon(PoseStack pose, MultiBufferSource source, float pTick, long gameTick, float height) {
        float width = 3.0f;
        pose.m_85836_();
        pose.m_85841_(1.0f, -1.0f, 1.0f);
        pose.m_85837_(0.0, (double)(-height / 2.0f), 0.0);
        float accurateTick = (float)Math.floorMod(gameTick, 90) + pTick;
        pose.m_252781_(Axis.f_252436_.m_252977_(accurateTick - 45.0f));
        VertexConsumer buffer = source.m_6299_(RenderType.m_110431_((ResourceLocation)this.BEACON_LOCATION));
        PoseStack.Pose posestack$pose = pose.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        GolemEquipmentRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, 0, 0.0f, width, 0.0f, 0.0f);
        GolemEquipmentRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, 0, width, 0.0f, 0.0f, 1.0f);
        GolemEquipmentRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, 0, 0.0f, -width, 1.0f, 1.0f);
        GolemEquipmentRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, 0, -width, 0.0f, 1.0f, 0.0f);
        pose.m_85849_();
    }

    protected void renderBeam(PoseStack pose, MultiBufferSource source, float pTick, float scale, long gameTick, float height, float[] color) {
        float width1 = 0.2f;
        float width2 = 0.25f;
        int length = 1024;
        pose.m_85836_();
        pose.m_85841_(1.0f, -1.0f, 1.0f);
        pose.m_85837_(0.0, (double)(height / 2.0f), 0.0);
        float accurateTick = (float)Math.floorMod(gameTick, 40) + pTick;
        float f2 = Mth.m_14187_((float)(accurateTick * 0.2f - (float)Mth.m_14143_((float)(accurateTick * 0.1f))));
        float colorR = color[0];
        float colorG = color[1];
        float colorB = color[2];
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_(accurateTick * 2.25f - 45.0f));
        float v1 = -1.0f + f2;
        float v2 = (float)length * scale * (0.5f / width1) + v1;
        GolemEquipmentRenderer.renderPart(pose, source.m_6299_(RenderType.m_110460_((ResourceLocation)this.BEAM_LOCATION, (boolean)false)), colorR, colorG, colorB, 1.0f, 0, length, 0.0f, width1, width1, 0.0f, -width1, 0.0f, 0.0f, -width1, 0.0f, 1.0f, v2, v1);
        pose.m_85849_();
        v1 = -1.0f + f2;
        v2 = (float)length * scale + v1;
        GolemEquipmentRenderer.renderPart(pose, source.m_6299_(RenderType.m_110460_((ResourceLocation)this.BEAM_LOCATION, (boolean)true)), colorR, colorG, colorB, 0.125f, 0, length, -width2, -width2, width2, -width2, -width2, width2, width2, width2, 0.0f, 1.0f, v2, v1);
        pose.m_85849_();
    }

    private static void renderPart(PoseStack pose, VertexConsumer buffer, float r, float g, float b, float a, int start, int end, float p_112164_, float p_112165_, float p_112166_, float p_112167_, float p_112168_, float p_112169_, float p_112170_, float p_112171_, float u1, float u2, float v1, float v2) {
        PoseStack.Pose posestack$pose = pose.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        GolemEquipmentRenderer.renderQuad(matrix4f, matrix3f, buffer, r, g, b, a, start, end, p_112164_, p_112165_, p_112166_, p_112167_, u1, u2, v1, v2);
        GolemEquipmentRenderer.renderQuad(matrix4f, matrix3f, buffer, r, g, b, a, start, end, p_112170_, p_112171_, p_112168_, p_112169_, u1, u2, v1, v2);
        GolemEquipmentRenderer.renderQuad(matrix4f, matrix3f, buffer, r, g, b, a, start, end, p_112166_, p_112167_, p_112170_, p_112171_, u1, u2, v1, v2);
        GolemEquipmentRenderer.renderQuad(matrix4f, matrix3f, buffer, r, g, b, a, start, end, p_112168_, p_112169_, p_112164_, p_112165_, u1, u2, v1, v2);
    }

    private static void renderQuad(Matrix4f pose, Matrix3f normal, VertexConsumer buffer, float r, float g, float b, float a, int y1, int y2, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        GolemEquipmentRenderer.addVertex(pose, normal, buffer, r, g, b, a, y2, x1, z1, u2, v1);
        GolemEquipmentRenderer.addVertex(pose, normal, buffer, r, g, b, a, y1, x1, z1, u2, v2);
        GolemEquipmentRenderer.addVertex(pose, normal, buffer, r, g, b, a, y1, x2, z2, u1, v2);
        GolemEquipmentRenderer.addVertex(pose, normal, buffer, r, g, b, a, y2, x2, z2, u1, v1);
    }

    private static void addVertex(Matrix4f pose, Matrix3f normal, VertexConsumer buffer, float r, float g, float b, float a, int y, float x, float z, float u, float v) {
        buffer.m_252986_(pose, x, (float)y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

