/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.create.modifier;

import dev.xkmc.modulargolems.compat.materials.create.CreateCompatRegistry;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;

public class MechBodyModifier
extends GolemModifier {
    public MechBodyModifier() {
        super(StatFilterType.HEAD, 1);
    }

    @Override
    public void onAiStep(AbstractGolemEntity<?, ?> golem, int level) {
        if (golem.m_9236_().m_5776_()) {
            return;
        }
        int threshold = 200;
        if (golem.f_19797_ % 20 != 0) {
            return;
        }
        int mobile = golem.getModifiers().getOrDefault(CreateCompatRegistry.MOBILE.get(), 0);
        int force = golem.getModifiers().getOrDefault(CreateCompatRegistry.FORCE.get(), 0);
        if (mobile == 0 && force == 0) {
            return;
        }
        MobEffectInstance mobileIns = golem.m_21124_((MobEffect)CreateCompatRegistry.EFF_MOBILE.get());
        MobEffectInstance forceIns = golem.m_21124_((MobEffect)CreateCompatRegistry.EFF_FORCE.get());
        int mobileTime = 0;
        int forceTime = 0;
        if (mobileIns != null) {
            mobileTime = mobileIns.m_19557_();
        }
        if (forceIns != null) {
            forceTime = forceIns.m_19557_();
        }
        if (mobile > 0 && mobileTime < threshold || force > 0 && forceTime < threshold) {
            int time;
            ItemStack fuel = golem.m_6298_(CreateCompatRegistry.DUMMY.asStack());
            LivingEntity self = golem;
            if (fuel.m_41619_()) {
                LivingEntity captain = golem.getCaptain();
                if (captain != null) {
                    self = captain;
                    fuel = captain.m_6298_(CreateCompatRegistry.DUMMY.asStack());
                }
                if (fuel.m_41619_()) {
                    return;
                }
            }
            if ((time = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_)) <= 0) {
                return;
            }
            ItemStack remain = fuel.getCraftingRemainingItem();
            if (!remain.m_41619_()) {
                self.m_19983_(remain);
            }
            fuel.m_41774_(1);
            if (mobile > 0) {
                golem.m_7292_(new MobEffectInstance((MobEffect)CreateCompatRegistry.EFF_MOBILE.get(), mobileTime + time, mobile - 1));
            }
            if (force > 0) {
                golem.m_7292_(new MobEffectInstance((MobEffect)CreateCompatRegistry.EFF_FORCE.get(), forceTime + time, force - 1));
            }
        }
    }

    @Override
    public InteractionResult interact(Player player, AbstractGolemEntity<?, ?> golem, InteractionHand hand, int value) {
        ItemStack stack = player.m_21120_(hand);
        int time = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_);
        if (time <= 0) {
            return InteractionResult.PASS;
        }
        int mobile = golem.getModifiers().getOrDefault(CreateCompatRegistry.MOBILE.get(), 0);
        int force = golem.getModifiers().getOrDefault(CreateCompatRegistry.FORCE.get(), 0);
        if (mobile == 0 && force == 0) {
            return InteractionResult.FAIL;
        }
        if (player.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        MobEffectInstance mobileIns = golem.m_21124_((MobEffect)CreateCompatRegistry.EFF_MOBILE.get());
        MobEffectInstance forceIns = golem.m_21124_((MobEffect)CreateCompatRegistry.EFF_FORCE.get());
        int mobileTime = 0;
        int forceTime = 0;
        if (mobileIns != null) {
            mobileTime = mobileIns.m_19557_();
        }
        if (forceIns != null) {
            forceTime = forceIns.m_19557_();
        }
        int maxFactor = (Integer)MGConfig.COMMON.mechMaxFuel.get();
        if (mobile > 0 && mobileTime >= time * maxFactor) {
            return InteractionResult.FAIL;
        }
        if (force > 0 && forceTime >= time * maxFactor) {
            return InteractionResult.FAIL;
        }
        if (mobile > 0) {
            golem.m_7292_(new MobEffectInstance((MobEffect)CreateCompatRegistry.EFF_MOBILE.get(), mobileTime + time, mobile - 1));
        }
        if (force > 0) {
            golem.m_7292_(new MobEffectInstance((MobEffect)CreateCompatRegistry.EFF_FORCE.get(), forceTime + time, force - 1));
        }
        if (!player.m_7500_()) {
            ItemStack remain = stack.getCraftingRemainingItem();
            stack.m_41774_(1);
            if (!remain.m_41619_()) {
                player.m_150109_().m_150079_(remain);
            }
        }
        float f1 = 1.0f + (golem.m_217043_().m_188501_() - golem.m_217043_().m_188501_()) * 0.2f;
        golem.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
        return InteractionResult.SUCCESS;
    }
}

