/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.botania;

import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaItem;

public class BotUtils {
    private final List<ManaItem> list;

    private static List<ManaItem> getManaItems(LivingEntity e) {
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)e).resolve();
        if (opt.isEmpty()) {
            return List.of();
        }
        List list = ((ICuriosItemHandler)opt.get()).findCurios(stack -> stack.getCapability(BotaniaForgeCapabilities.MANA_ITEM).resolve().isPresent());
        ArrayList<ManaItem> ans = new ArrayList<ManaItem>();
        for (SlotResult item : list) {
            Optional optMana = item.stack().getCapability(BotaniaForgeCapabilities.MANA_ITEM).resolve();
            if (optMana.isEmpty()) continue;
            ans.add((ManaItem)optMana.get());
        }
        return ans;
    }

    public BotUtils(LivingEntity e) {
        this.list = BotUtils.getManaItems(e);
    }

    public int count() {
        return this.list.size();
    }

    public int getMana() {
        int total = 0;
        for (ManaItem manaItem : this.list) {
            total += manaItem.getMana();
        }
        return total;
    }

    public int getMaxMana() {
        int total = 0;
        for (ManaItem manaItem : this.list) {
            total += manaItem.getMaxMana();
        }
        return total;
    }

    public int consumeMana(int target) {
        int consumed = 0;
        for (ManaItem manaItem : this.list) {
            int remainMana = manaItem.getMana();
            if (remainMana <= 0) continue;
            int cost = Math.min(remainMana, target);
            consumed += cost;
            manaItem.addMana(-cost);
            if ((target -= cost) != 0) continue;
            break;
        }
        return consumed;
    }

    public int generateMana(int available) {
        for (ManaItem manaItem : this.list) {
            int space = manaItem.getMaxMana() - manaItem.getMana();
            if (space <= 0) continue;
            int toGen = Math.min(available, space);
            manaItem.addMana(toGen);
            if ((available -= toGen) != 0) continue;
            break;
        }
        return available;
    }

    private static String parse(int mana) {
        if (mana < 10000) {
            return "" + mana;
        }
        if ((mana /= 1000) < 10000) {
            return mana + "k";
        }
        return mana / 1000 + "M";
    }

    public static Component getDesc(LivingEntity golem) {
        BotUtils bot = new BotUtils(golem);
        if (bot.count() == 0) {
            return MGLangData.BOT_NO_RING.get(new Object[0]).m_130940_(ChatFormatting.RED);
        }
        return MGLangData.BOT_MANA.get(BotUtils.parse(bot.getMana()), BotUtils.parse(bot.getMaxMana())).m_130940_(ChatFormatting.LIGHT_PURPLE);
    }
}

