/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.jei;

import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.compat.curio.CurioCompatRegistry;
import dev.xkmc.modulargolems.compat.jei.CustomRecipeEvent;
import dev.xkmc.modulargolems.compat.jei.GolemAddSlotExtension;
import dev.xkmc.modulargolems.compat.jei.GolemAssemblyExtension;
import dev.xkmc.modulargolems.compat.jei.GolemReplaceExtension;
import dev.xkmc.modulargolems.compat.jei.GuiProperties;
import dev.xkmc.modulargolems.compat.jei.ItemFilterHandler;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.item.golem.GolemFacade;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.content.menu.config.ToggleGolemConfigScreen;
import dev.xkmc.modulargolems.content.menu.equipment.EquipmentsScreen;
import dev.xkmc.modulargolems.content.menu.filter.ItemConfigScreen;
import dev.xkmc.modulargolems.content.menu.path.PathConfigScreen;
import dev.xkmc.modulargolems.content.menu.tabs.ITabScreen;
import dev.xkmc.modulargolems.content.menu.target.TargetConfigScreen;
import dev.xkmc.modulargolems.content.recipe.GolemAssembleRecipe;
import dev.xkmc.modulargolems.content.recipe.GolemReplaceRecipe;
import dev.xkmc.modulargolems.content.recipe.GolemSmithAddSlotRecipe;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@JeiPlugin
public class GolemJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("modulargolems", "main");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (Item item : GolemPart.LIST) {
            registration.registerSubtypeInterpreter(item, GolemJEIPlugin::partSubtype);
        }
        registration.registerSubtypeInterpreter((Item)GolemItems.FACADE.get(), GolemJEIPlugin::facadeSubtype);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        GolemMaterialConfig config = GolemMaterialConfig.get();
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        GolemJEIPlugin.addPartCraftRecipes(recipes, config, registration.getVanillaRecipeFactory());
        GolemJEIPlugin.addRepairRecipes(recipes, config, registration.getVanillaRecipeFactory());
        GolemJEIPlugin.addUpgradeRecipes(recipes, config, registration.getVanillaRecipeFactory());
        registration.addRecipes(RecipeTypes.ANVIL, recipes);
        MinecraftForge.EVENT_BUS.post((Event)new CustomRecipeEvent(registration));
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(GolemAssembleRecipe.class, GolemAssemblyExtension::new);
        registration.getCraftingCategory().addCategoryExtension(GolemReplaceRecipe.class, GolemReplaceExtension::new);
        registration.getSmithingCategory().addExtension(GolemSmithAddSlotRecipe.class, (ISmithingCategoryExtension)new GolemAddSlotExtension());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(ItemConfigScreen.class, (IGhostIngredientHandler)new ItemFilterHandler());
        registration.addGuiScreenHandler(EquipmentsScreen.class, GolemJEIPlugin::create);
        registration.addGuiScreenHandler(ToggleGolemConfigScreen.class, GolemJEIPlugin::create);
        registration.addGuiScreenHandler(ItemConfigScreen.class, GolemJEIPlugin::create);
        registration.addGuiScreenHandler(TargetConfigScreen.class, GolemJEIPlugin::create);
        registration.addGuiScreenHandler(PathConfigScreen.class, GolemJEIPlugin::create);
        CurioCompatRegistry.onJEIRegistry(e -> registration.addGuiScreenHandler((Class)Wrappers.cast((Object)e), x$0 -> GolemJEIPlugin.create((ITabScreen)x$0)));
    }

    @Nullable
    public static IGuiProperties create(ITabScreen screen) {
        if (screen.screenWidth() <= 0 || screen.screenHeight() <= 0) {
            return null;
        }
        int x = screen.getGuiLeft();
        int y = screen.getGuiTop();
        int width = screen.getXSize() + 32;
        int height = screen.getYSize();
        if (width <= 0 || height <= 0) {
            return null;
        }
        return new GuiProperties(screen.asScreen().getClass(), x, y, width, height, screen.screenWidth(), screen.screenHeight());
    }

    private static String partSubtype(ItemStack stack, UidContext ctx) {
        return GolemPart.getMaterial(stack).orElse(GolemMaterial.EMPTY).toString();
    }

    private static String facadeSubtype(ItemStack stack, UidContext ctx) {
        return GolemFacade.getMaterial(stack).toString();
    }

    private static void addPartCraftRecipes(List<IJeiAnvilRecipe> recipes, GolemMaterialConfig config, IVanillaRecipeFactory factory) {
        for (ResourceLocation mat : config.getAllMaterials()) {
            recipes.add(factory.createAnvilRecipe(new ItemStack(GolemItems.EMPTY_UPGRADE), List.of(config.getRepairIngredient(mat).m_43908_()), List.of(GolemFacade.setMaterial(GolemItems.FACADE.asStack(), mat))));
            ItemStack[] arr = config.getCraftIngredient(mat).m_43908_();
            boolean special = false;
            for (ItemStack stack : arr) {
                if (!stack.m_204117_(MGTagGen.SPECIAL_CRAFT)) continue;
                special = true;
                break;
            }
            if (special) continue;
            for (GolemPart golemPart : GolemPart.LIST) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (ItemStack stack : arr) {
                    list.add(new ItemStack((ItemLike)stack.m_41720_(), golemPart.count));
                }
                recipes.add(factory.createAnvilRecipe(new ItemStack((ItemLike)golemPart), list, List.of(GolemPart.setMaterial(new ItemStack((ItemLike)golemPart), mat))));
            }
        }
    }

    private static void addRepairRecipes(List<IJeiAnvilRecipe> recipes, GolemMaterialConfig config, IVanillaRecipeFactory factory) {
        for (GolemHolder<?, ?> types : GolemType.GOLEM_TYPE_TO_ITEM.values()) {
            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
            ArrayList<ItemStack> material = new ArrayList<ItemStack>();
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            for (ResourceLocation mat : config.getAllMaterials()) {
                ItemStack golem = new ItemStack(types);
                for (IGolemPart part : types.getEntityType().values()) {
                    GolemHolder.addMaterial(golem, part.toItem(), mat);
                }
                ItemStack damaged = golem.m_41777_();
                damaged.m_41784_().m_128350_("golem_display", 0.75f);
                input.add(damaged);
                ItemStack[] arr = config.getRepairIngredient(mat).m_43908_();
                material.add(new ItemStack((ItemLike)(arr.length > 0 ? arr[0].m_41720_() : Items.f_42127_)));
                golem.m_41784_().m_128350_("golem_display", 1.0f);
                result.add(golem);
            }
            recipes.add(factory.createAnvilRecipe(input, material, result));
        }
    }

    private static void addUpgradeRecipes(List<IJeiAnvilRecipe> recipes, GolemMaterialConfig config, IVanillaRecipeFactory factory) {
        for (UpgradeItem item : UpgradeItem.LIST) {
            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
            ArrayList<ItemStack> material = new ArrayList<ItemStack>();
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            for (GolemHolder<?, ?> types : GolemType.GOLEM_TYPE_TO_ITEM.values()) {
                input.add(new ItemStack(types));
            }
            material.add(new ItemStack((ItemLike)item));
            for (GolemHolder<?, ?> types : GolemType.GOLEM_TYPE_TO_ITEM.values()) {
                result.add(GolemHolder.addUpgrade(new ItemStack(types), item));
            }
            recipes.add(factory.createAnvilRecipe(input, material, result));
        }
    }
}

