/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.loader.forge;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.fengming.vaultpatcher_asm.VaultPatcher;
import me.fengming.vaultpatcher_asm.config.VaultPatcherConfig;
import me.fengming.vaultpatcher_asm.core.patch.ClassPatcher;
import me.fengming.vaultpatcher_asm.core.utils.Utils;
import me.fengming.vaultpatcher_asm.loader.forge.ForgeClassTransformer;
import me.fengming.vaultpatcher_asm.loader.forge.ForgeMinecraftTransformer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

public class VPTransformationService
implements ITransformationService {
    private boolean oldVersion = false;

    @NotNull
    public String name() {
        return "vaultpatcher";
    }

    public void initialize(IEnvironment environment) {
        String minecraftVersion;
        VaultPatcher.LOGGER.warn("[VaultPatcher] Loading VPTransformationService!");
        Optional minecraftPathOptional = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get());
        if (!minecraftPathOptional.isPresent()) {
            VaultPatcher.LOGGER.error("[VaultPatcher] Minecraft path not found!");
            return;
        }
        if (environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.ASSETSDIR.get()).isPresent()) {
            Utils.isClient = true;
        }
        Utils.mcVersion = minecraftVersion = VPTransformationService.getMinecraftVersion();
        if (Utils.isBlank(minecraftVersion)) {
            VaultPatcher.LOGGER.error("[VaultPatcher] Failed to get minecraft version!");
        }
        if (VPTransformationService.isOldVersion(minecraftVersion)) {
            VaultPatcher.LOGGER.warn("[VaultPatcher] Disable dynamic replace because the game version is 1.16.5 and below (your version: " + minecraftVersion + ")");
            this.oldVersion = true;
        }
        Path mcPath = (Path)minecraftPathOptional.get();
        VaultPatcher.init(mcPath);
        VaultPatcher.LOGGER.warn("[VaultPatcher] TS DONE!");
    }

    public static boolean isOldVersion(String version) {
        String[] _116 = new String[]{"1", "16", "5"};
        String[] ver = version.split("\\.", 3);
        for (int i = 0; i < Math.min(_116.length, ver.length); ++i) {
            int comparison = _116[i].compareTo(ver[i]);
            if (comparison < 0) {
                return false;
            }
            if (comparison <= 0) continue;
            return true;
        }
        return _116.length >= ver.length;
    }

    private static String getMinecraftVersion() {
        try {
            Launcher Instance_Launcher = Launcher.INSTANCE;
            Field Field_argumentHandler = Instance_Launcher.getClass().getDeclaredField("argumentHandler");
            Field_argumentHandler.setAccessible(true);
            Object Instance_argumentHandler = Field_argumentHandler.get(Instance_Launcher);
            Field Field_args = Instance_argumentHandler.getClass().getDeclaredField("args");
            Field_args.setAccessible(true);
            String[] Instance_args = (String[])Field_args.get(Instance_argumentHandler);
            for (int i = 0; i < Instance_args.length; ++i) {
                if (!Instance_args[i].equals("--fml.mcVersion")) continue;
                return Instance_args[i + 1];
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("WHY ARE YOU HERE!!??");
        }
        return "";
    }

    public void beginScanning(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }

    public List<ITransformer> transformers() {
        ArrayList<ITransformer> list = new ArrayList<ITransformer>();
        if (VaultPatcherConfig.isEnableClassPatch()) {
            ClassPatcher.getPatchMap().forEach((k, v) -> list.add(new ITransformer<ClassNode>(){

                public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
                    VaultPatcher.debugInfo("Using Patch: " + input.name);
                    return v;
                }

                public TransformerVoteResult castVote(ITransformerVotingContext context) {
                    return TransformerVoteResult.YES;
                }

                public Set<ITransformer.Target> targets() {
                    return new HashSet<ITransformer.Target>(){
                        {
                            this.add(ITransformer.Target.targetClass((String)k));
                        }
                    };
                }
            }));
        }
        list.addAll(Utils.translationInfos.stream().map(ForgeClassTransformer::new).collect(Collectors.toList()));
        list.add(new ForgeClassTransformer(null));
        if (!this.oldVersion) {
            list.add(new ForgeMinecraftTransformer());
        }
        return list;
    }
}

