/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.core.utils;

import cpw.mods.modlauncher.api.ITransformer;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import me.fengming.vaultpatcher_asm.VaultPatcher;
import me.fengming.vaultpatcher_asm.config.DebugMode;
import me.fengming.vaultpatcher_asm.config.Pair;
import me.fengming.vaultpatcher_asm.config.Pairs;
import me.fengming.vaultpatcher_asm.config.TranslationInfo;
import me.fengming.vaultpatcher_asm.config.VaultPatcherConfig;
import me.fengming.vaultpatcher_asm.core.utils.I18n;
import me.fengming.vaultpatcher_asm.plugin.VaultPatcherPlugin;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class Utils {
    public static final List<TranslationInfo> EMPTY_LIST = new ArrayList<TranslationInfo>();
    public static List<TranslationInfo> translationInfos = new ArrayList<TranslationInfo>();
    public static List<TranslationInfo> dynTranslationInfos = new ArrayList<TranslationInfo>();
    public static Path mcPath = null;
    public static String mcVersion = null;
    public static boolean isClient = false;
    public static boolean needStacktrace = false;

    public static String getGameVersion() {
        return mcVersion;
    }

    public static Path getPluginConfigPath(VaultPatcherPlugin plugin) {
        return mcPath.resolve("config").resolve("vaultpatcher_asm").resolve("plugins").resolve(plugin.getName());
    }

    public static Path getVpPath() {
        return mcPath.resolve("vaultpatcher");
    }

    public static void printDebugInfo(int o, String s, String m, String ret, String c, TranslationInfo info) {
        DebugMode debug = VaultPatcherConfig.getDebugMode();
        if (!debug.isEnable()) {
            return;
        }
        String format = debug.getOutputFormat();
        VaultPatcher.LOGGER.info("[VaultPatcher] Trying replacing!");
        VaultPatcher.LOGGER.info(format.replace("<source>", s).replace("<target>", ret).replace("<method>", m).replace("<info>", info.toString()).replace("<class>", c).replace("<ordinal>", String.valueOf(o)));
    }

    public static void printDebugInfo(String s, String m, String ret, String c, TranslationInfo info) {
        DebugMode debug = VaultPatcherConfig.getDebugMode();
        if (!debug.isEnable()) {
            return;
        }
        String format = debug.getOutputFormat();
        VaultPatcher.LOGGER.info("[VaultPatcher] Trying replacing!");
        VaultPatcher.LOGGER.info(format.replace("<source>", s).replace("<target>", ret).replace("<method>", m).replace("<info>", info.toString()).replace("<class>", c).replace("<ordinal>", "Unknown"));
    }

    public static byte[] nodeToBytes(ClassNode node) {
        ClassWriter wr = new ClassWriter(0);
        node.accept((ClassVisitor)wr);
        return wr.toByteArray();
    }

    public static Set<ITransformer.Target> getTarget(TranslationInfo info) {
        HashSet<ITransformer.Target> targets = new HashSet<ITransformer.Target>();
        if (info == null) {
            targets.addAll(Utils.getExpandTargets());
        } else {
            String name = info.getTargetClassInfo().getName();
            if (!Utils.isBlank(name)) {
                targets.add(ITransformer.Target.targetClass((String)Utils.rawPackage(name)));
            }
        }
        targets.iterator().forEachRemaining(t -> VaultPatcher.debugInfo(String.format("[VaultPatcher] VPClassTransformer Target = %s", t.getClassName())));
        return targets;
    }

    public static Set<ITransformer.Target> getExpandTargets() {
        HashSet<ITransformer.Target> targets = new HashSet<ITransformer.Target>();
        targets.addAll(VaultPatcherConfig.getApplyMods().stream().collect(ArrayList::new, (list, s) -> Utils.getClassesNameByJar(mcPath.resolve("mods").resolve(s + ".jar").toString()).forEach(s1 -> list.add(ITransformer.Target.targetClass((String)s1.substring(0, s1.length() - 6)))), ArrayList::addAll));
        targets.addAll(VaultPatcherConfig.getClasses().stream().collect(ArrayList::new, (list, s) -> list.add(ITransformer.Target.targetClass((String)Utils.rawPackage(s))), ArrayList::addAll));
        return targets;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getClassesNameByJar(String jarPath) {
        try (JarFile jarFile = new JarFile(jarPath);){
            List<String> list = jarFile.stream().map(ZipEntry::getName).filter(name -> name.endsWith(".class")).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed loading jar: " + jarPath, e);
        }
    }

    public static String rawPackage(String s) {
        return s.replace('.', '/');
    }

    public static String matchPairs(Pairs p, String source, boolean dyn) {
        if (source.isEmpty()) {
            return source;
        }
        String v = p.getValue(source);
        if (dyn && p.isNonFullMatch()) {
            for (Pair<String, String> pair : p.getList()) {
                if (((String)pair.second).charAt(0) != '@' || !source.contains((CharSequence)pair.first)) continue;
                v = source.replace((CharSequence)pair.first, ((String)pair.second).substring(1));
            }
        }
        return v == null ? source : v;
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return false;
        }
        if (s.isEmpty()) {
            return true;
        }
        for (int i = 0; i < s.getBytes(StandardCharsets.UTF_8).length; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getI18n(String key) {
        return I18n.getValue(key);
    }

    public static String filePathToClassName(Path path, Path root) {
        String s = root.relativize(path).toString();
        return s.substring(0, s.length() - 6).replace(File.separatorChar, '/');
    }
}

