/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.core.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import me.fengming.vaultpatcher_asm.VaultPatcher;
import me.fengming.vaultpatcher_asm.core.utils.Utils;

public class I18n {
    private static final Gson GSON = new Gson();
    private static String currentCode = "en_us";
    private static Map<String, String> langugesMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Path mcPath) {
        BufferedReader br1 = null;
        BufferedReader br2 = null;
        try {
            if (Files.exists(mcPath.resolve("options.txt"), new LinkOption[0])) {
                Path i18nPath;
                String line;
                br1 = Files.newBufferedReader(mcPath.resolve("options.txt"));
                while ((line = br1.readLine()) != null) {
                    if (!line.startsWith("lang:")) continue;
                    currentCode = line.substring(5);
                    break;
                }
                if (Files.notExists(i18nPath = Utils.getVpPath().resolve("i18n"), new LinkOption[0])) {
                    Files.createDirectories(i18nPath, new FileAttribute[0]);
                }
                if (Files.notExists(i18nPath.resolve(currentCode + ".json"), new LinkOption[0])) {
                    VaultPatcher.LOGGER.error("Not found file " + currentCode + ".json");
                    return;
                }
                br2 = Files.newBufferedReader(i18nPath.resolve(currentCode + ".json"));
                langugesMap = (Map)GSON.fromJson((Reader)br2, new TypeToken<Map<String, String>>(){}.getType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br1 != null) {
                    br1.close();
                }
                if (br2 != null) {
                    br2.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getValue(String key) {
        return langugesMap.getOrDefault(key, key);
    }
}

