/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.core.patch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import me.fengming.vaultpatcher_asm.config.VaultPatcherConfig;
import me.fengming.vaultpatcher_asm.core.utils.Utils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ClassPatcher {
    private static final Map<String, ClassNode> patchMap = new HashMap<String, ClassNode>();

    public static Map<String, ClassNode> getPatchMap() {
        return patchMap;
    }

    public static void init(Path path) throws IOException {
        if (!VaultPatcherConfig.isEnableClassPatch()) {
            return;
        }
        File file = path.toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        ClassPatcher.traverse(file, path);
    }

    private static void traverse(File file, Path root) throws IOException {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children == null || children.length == 0) {
                return;
            }
            for (File child : children) {
                ClassPatcher.traverse(child, root);
            }
        } else if (file.getName().endsWith(".class")) {
            String className = Utils.filePathToClassName(file.toPath(), root);
            ClassNode node = new ClassNode();
            ClassReader cr = new ClassReader(Files.newInputStream(file.toPath(), new OpenOption[0]));
            cr.accept((ClassVisitor)node, 0);
            patchMap.putIfAbsent(className, node);
        }
    }

    public static ClassNode patch(ClassNode original) {
        ClassNode patched = ClassPatcher.patch(original.name);
        return patched == null ? original : patched;
    }

    public static ClassNode patch(String className) {
        return patchMap.getOrDefault(className, null);
    }
}

