/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.config;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import me.fengming.vaultpatcher_asm.VaultPatcher;
import me.fengming.vaultpatcher_asm.config.ModuleInfo;
import me.fengming.vaultpatcher_asm.config.Pairs;
import me.fengming.vaultpatcher_asm.config.TargetClassInfo;
import me.fengming.vaultpatcher_asm.config.TranslationInfo;
import me.fengming.vaultpatcher_asm.config.VaultPatcherConfig;
import me.fengming.vaultpatcher_asm.core.utils.Utils;

public class VaultPatcherModule {
    private final Path patchFile;
    private final List<TranslationInfo> translationInfoList = new ArrayList<TranslationInfo>();
    private boolean dynamic;

    public VaultPatcherModule(String patchFile) {
        VaultPatcher.debugInfo("[VaultPatcher] Found Module " + patchFile);
        Path p = VaultPatcherConfig.config.resolve(patchFile);
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create", e);
        }
        this.patchFile = p;
    }

    public void read(JsonReader reader) throws IOException {
        reader.beginArray();
        ModuleInfo moduleInfo = new ModuleInfo();
        moduleInfo.readJson(reader);
        this.dynamic = moduleInfo.isDataDynamic();
        VaultPatcher.debugInfo(String.format("[VaultPatcher] Loading %s!", moduleInfo.getInfoName()));
        VaultPatcher.debugInfo("[VaultPatcher] About Information:");
        VaultPatcher.debugInfo(String.format("[VaultPatcher] Author(s): %s", moduleInfo.getInfoAuthors()));
        VaultPatcher.debugInfo(String.format("[VaultPatcher] Mod(s): %s", moduleInfo.getInfoMods()));
        VaultPatcher.debugInfo(String.format("[VaultPatcher] Description: %s", moduleInfo.getInfoDesc()));
        VaultPatcher.debugInfo(String.format("[VaultPatcher] Dynamic: %s", moduleInfo.isDataDynamic()));
        VaultPatcher.debugInfo(String.format("[VaultPatcher] I18n: %s", moduleInfo.isDataI18n()));
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.beginObject();
            ArrayList<TargetClassInfo> targetClassInfos = new ArrayList<TargetClassInfo>();
            TranslationInfo.Mutable mutable = new TranslationInfo.Mutable();
            Pairs pairs = new Pairs(this.dynamic);
            block20: while (reader.peek() != JsonToken.END_OBJECT) {
                switch (reader.nextName()) {
                    case "s": 
                    case "target_classes": {
                        TargetClassInfo targetClassInfo;
                        reader.beginArray();
                        while (reader.peek() != JsonToken.END_ARRAY) {
                            targetClassInfo = new TargetClassInfo();
                            targetClassInfo.readJson(reader);
                            targetClassInfos.add(targetClassInfo);
                        }
                        reader.endArray();
                        continue block20;
                    }
                    case "t": 
                    case "target_class": {
                        TargetClassInfo targetClassInfo = new TargetClassInfo();
                        targetClassInfo.readJson(reader);
                        targetClassInfos.add(targetClassInfo);
                        continue block20;
                    }
                    case "k": 
                    case "key": {
                        pairs.setKey(reader.nextString());
                        continue block20;
                    }
                    case "v": 
                    case "value": {
                        pairs.setValue(moduleInfo.isDataI18n() ? Utils.getI18n(reader.nextString()) : reader.nextString());
                        continue block20;
                    }
                    case "p": 
                    case "pairs": {
                        pairs.readJson(reader, moduleInfo.isDataI18n());
                        continue block20;
                    }
                }
                reader.skipValue();
            }
            mutable.setPairs(pairs);
            for (TargetClassInfo targetClassInfo : targetClassInfos) {
                this.translationInfoList.add(mutable.setTargetClassInfo(targetClassInfo));
            }
            reader.endObject();
        }
        reader.endArray();
    }

    public void write(JsonWriter writer) throws IOException {
        writer.setIndent("  ");
        writer.beginArray();
        ModuleInfo moduleInfo = new ModuleInfo();
        moduleInfo.writeJson(writer);
        TranslationInfo translationInfo = new TranslationInfo();
        translationInfo.write(writer);
        writer.endArray();
        writer.close();
    }

    public void read() throws IOException {
        Throwable throwable;
        if (Files.notExists(this.patchFile, new LinkOption[0])) {
            Files.createFile(this.patchFile, new FileAttribute[0]);
            throwable = null;
            try (JsonWriter jw = new JsonWriter((Writer)Files.newBufferedWriter(this.patchFile, StandardCharsets.UTF_8, new OpenOption[0]));){
                jw.setIndent("  ");
                this.write(jw);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        throwable = null;
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(this.patchFile, new OpenOption[0]), StandardCharsets.UTF_8));){
            this.read(jsonReader);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public List<TranslationInfo> getTranslationInfoList() {
        return this.dynamic ? Utils.EMPTY_LIST : this.translationInfoList;
    }

    public List<TranslationInfo> getDynTranslationInfoList() {
        return this.dynamic ? this.translationInfoList : Utils.EMPTY_LIST;
    }
}

