/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.config;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import me.fengming.vaultpatcher_asm.config.Pairs;
import me.fengming.vaultpatcher_asm.config.TargetClassInfo;

public class TranslationInfo {
    private final TargetClassInfo targetClassInfo;
    private final Pairs pairs;

    public TranslationInfo(TargetClassInfo targetClassInfo, Pairs pairs) {
        this.targetClassInfo = targetClassInfo;
        this.pairs = pairs;
    }

    public TranslationInfo() {
        this.targetClassInfo = new TargetClassInfo();
        this.pairs = new Pairs();
    }

    public void write(JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.name("target_class");
        this.getTargetClassInfo().writeJson(writer);
        writer.name("pairs").beginArray().endArray();
        writer.endObject();
    }

    public TargetClassInfo getTargetClassInfo() {
        return this.targetClassInfo;
    }

    public Pairs getPairs() {
        return this.pairs;
    }

    public void setKey(String key) {
        this.pairs.setKey(key);
    }

    public void setValue(String value) {
        this.pairs.setValue(value);
    }

    public String toString() {
        return "TranslationInfo{targetClassInfo=" + this.targetClassInfo + ", pairs=" + this.pairs + '}';
    }

    public static class Mutable
    extends TranslationInfo {
        private TargetClassInfo targetClassInfo;
        private Pairs pairs;

        @Override
        public Pairs getPairs() {
            return this.pairs;
        }

        @Override
        public TargetClassInfo getTargetClassInfo() {
            return this.targetClassInfo;
        }

        public TranslationInfo setPairs(Pairs pairs) {
            this.pairs = pairs;
            return this.toImmutable();
        }

        public TranslationInfo setTargetClassInfo(TargetClassInfo targetClassInfo) {
            this.targetClassInfo = targetClassInfo;
            return this.toImmutable();
        }

        public TranslationInfo toImmutable() {
            return new TranslationInfo(this.targetClassInfo, this.pairs);
        }
    }
}

