/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.config;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import me.fengming.vaultpatcher_asm.core.utils.Utils;

public class TargetClassInfo {
    private String name = "";
    private String method = "";
    private String local = "";
    private int ordinal = -1;
    private boolean i18n = false;
    private MatchMode matchMode = MatchMode.FULL;
    private LocalMode localMode = LocalMode.NONE;

    public void readJson(JsonReader reader) throws IOException {
        reader.beginObject();
        block19: while (reader.peek() != JsonToken.END_OBJECT) {
            switch (reader.nextName()) {
                case "n": 
                case "name": {
                    this.setName(reader.nextString());
                    continue block19;
                }
                case "m": 
                case "method": {
                    this.setMethod(reader.nextString());
                    continue block19;
                }
                case "l": 
                case "local": {
                    this.setLocal(reader.nextString());
                    continue block19;
                }
                case "o": 
                case "ordinal": {
                    this.setOrdinal(reader.nextInt());
                    continue block19;
                }
                case "i": 
                case "i18n": {
                    this.setI18n(reader.nextBoolean());
                    continue block19;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    public void writeJson(JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.name("name").value("com.example.mod.SomethingClass");
        writer.name("method").value("doSomething");
        writer.name("local").value("Lsomething");
        writer.name("i18n").value(false);
        writer.name("ordinal").value(209L);
        writer.endObject();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (Utils.isBlank(name)) {
            return;
        }
        char first = name.charAt(0);
        if (first == '@') {
            this.matchMode = MatchMode.STARTS;
            this.name = name.substring(1);
        } else if (first == '#') {
            this.matchMode = MatchMode.ENDS;
            this.name = name.substring(1);
        } else {
            this.matchMode = MatchMode.FULL;
            this.name = name;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getLocal() {
        return this.local;
    }

    public void setLocal(String local) {
        if (Utils.isBlank(local)) {
            this.local = local;
        } else {
            char first = local.charAt(0);
            this.local = local.substring(1);
            this.localMode = first == 'V' ? LocalMode.LOCAL_VARIABLE : (first == 'M' ? LocalMode.METHOD_RETURN : (first == 'R' ? LocalMode.CALL_RETURN : (first == 'G' || first == 'F' ? LocalMode.GLOBAL_VARIABLE : LocalMode.NONE)));
        }
    }

    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    public LocalMode getLocalMode() {
        return this.localMode;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public boolean isI18n() {
        return this.i18n;
    }

    public void setI18n(boolean i18n) {
        this.i18n = i18n;
    }

    public String toString() {
        return "TargetClassInfo{name='" + this.name + '\'' + ", method='" + this.method + '\'' + ", local='" + this.local + '\'' + ", ordinal=" + this.ordinal + ", matchMode=" + (Object)((Object)this.matchMode) + ", localMode=" + (Object)((Object)this.localMode) + '}';
    }

    public static enum MatchMode {
        FULL,
        STARTS,
        ENDS;

    }

    public static enum LocalMode {
        CALL_RETURN,
        LOCAL_VARIABLE,
        METHOD_RETURN,
        GLOBAL_VARIABLE,
        NONE;

    }
}

