/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.config;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.fengming.vaultpatcher_asm.config.Pair;
import me.fengming.vaultpatcher_asm.core.utils.Utils;

public class Pairs {
    private HashMap<String, String> pairsMap = null;
    private String lastKey = null;
    private String lastValue = null;
    private List<Pair<String, String>> pairsList = null;
    private boolean nonFullMatch = false;
    private final boolean dyn;

    public Pairs() {
        this(false);
    }

    public Pairs(boolean dyn) {
        this.dyn = dyn;
        if (dyn) {
            this.pairsList = new ArrayList<Pair<String, String>>();
        } else {
            this.pairsMap = new HashMap();
        }
    }

    public void readJson(JsonReader reader, boolean i18n) throws IOException {
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.beginObject();
            block11: while (reader.peek() != JsonToken.END_OBJECT) {
                switch (reader.nextName()) {
                    case "k": 
                    case "key": {
                        this.setKey(reader.nextString());
                        continue block11;
                    }
                    case "v": 
                    case "value": {
                        this.setValue(i18n ? Utils.getI18n(reader.nextString()) : reader.nextString());
                        continue block11;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
        }
        reader.endArray();
    }

    public HashMap<String, String> getMap() {
        return this.pairsMap;
    }

    public List<Pair<String, String>> getList() {
        return this.pairsList;
    }

    public void setKey(String key) {
        if (this.lastValue == null) {
            this.lastKey = key;
            return;
        }
        if (this.dyn) {
            this.nonFullMatch |= this.lastValue.length() > 0 && this.lastValue.charAt(0) == '@';
            this.pairsList.add(new Pair<String, String>(key, this.lastValue));
        } else {
            this.pairsMap.put(key, this.lastValue);
        }
        this.lastValue = null;
        this.lastKey = null;
    }

    public void setValue(String value) {
        if (this.lastKey == null) {
            this.lastValue = value;
            return;
        }
        if (this.dyn) {
            this.nonFullMatch |= value.length() > 0 && value.charAt(0) == '@';
            this.pairsList.add(new Pair<String, String>(this.lastKey, value));
        } else {
            this.pairsMap.put(this.lastKey, value);
        }
        this.lastValue = null;
        this.lastKey = null;
    }

    public String getValue(String key) {
        if (this.dyn) {
            if (this.nonFullMatch) {
                return null;
            }
            Pair pair = this.pairsList.stream().filter(e -> ((String)e.first).equals(key)).findFirst().orElse(null);
            return pair == null ? key : (String)pair.second;
        }
        return this.pairsMap.getOrDefault(key, key);
    }

    public Pairs merge(Pairs other) {
        if (this.dyn != other.dyn) {
            throw new RuntimeException("Dynamic Mode of the source pairs is different from that of the other pairs!");
        }
        if (this.dyn) {
            this.pairsList.addAll(other.pairsList);
        } else {
            this.pairsMap.putAll(other.pairsMap);
        }
        return this;
    }

    public boolean isNonFullMatch() {
        return this.nonFullMatch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dyn) {
            this.pairsList.forEach(e -> sb.append("'").append((String)e.first).append("'='").append((String)e.second).append("'").append(","));
        } else {
            this.pairsMap.forEach((key, value) -> sb.append("'").append((String)key).append("'='").append((String)value).append("'").append(","));
        }
        sb.deleteCharAt(sb.length() - 1).append("}");
        return sb.toString();
    }
}

