/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.utils;

import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import customskinloader.CustomSkinLoader;
import customskinloader.utils.HttpTextureUtil;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import sun.misc.Unsafe;

public class TextureUtil {
    private static final MethodHandles.Lookup IMPL_LOOKUP = ((Supplier<MethodHandles.Lookup>)() -> {
        try {
            Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            Unsafe theUnsafe = (Unsafe)theUnsafeField.get(null);
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            return (MethodHandles.Lookup)theUnsafe.getObject(theUnsafe.staticFieldBase(implLookupField), theUnsafe.staticFieldOffset(implLookupField));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }).get();

    public static String parseBase64Texture(String base64) {
        byte[] capeBytes = Base64.decodeBase64((String)base64);
        String hash = HttpTextureUtil.getHash(capeBytes);
        File cacheFile = HttpTextureUtil.getCacheFile(hash);
        String fakeUrl = HttpTextureUtil.getBase64FakeUrl(hash);
        try {
            FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])capeBytes);
            CustomSkinLoader.logger.info("Saved base64 image to " + cacheFile);
            return fakeUrl;
        }
        catch (Exception e) {
            CustomSkinLoader.logger.warning("Error parsing base64 image: " + base64);
            return null;
        }
    }

    public static String fromUUID(UUID value) {
        return value.toString().replace("-", "");
    }

    public static enum AuthlibField {
        PROPERTY_NAME(Property.class, "name", String.class),
        PROPERTY_VALUE(Property.class, "value", String.class),
        PROPERTY_SIGNATURE(Property.class, "signature", String.class),
        MINECRAFT_PROFILE_PROPERTIES_RESPONSE_ID(MinecraftProfilePropertiesResponse.class, "id", UUID.class),
        MINECRAFT_PROFILE_PROPERTIES_RESPONSE_NAME(MinecraftProfilePropertiesResponse.class, "name", String.class),
        MINECRAFT_PROFILE_PROPERTIES_RESPONSE_PROPERTIES(MinecraftProfilePropertiesResponse.class, "properties", PropertyMap.class),
        MINECRAFT_TEXTURES_PAYLOAD_TEXTURES(MinecraftTexturesPayload.class, "textures", Map.class);

        private final MethodHandle getter;
        private final MethodHandle setter;

        private AuthlibField(Class<?> clazz, String name, Class<?> returnType) {
            try {
                this.getter = IMPL_LOOKUP.findGetter(clazz, name, returnType);
                this.setter = IMPL_LOOKUP.findSetter(clazz, name, returnType);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public <R> R get(Object o) {
            try {
                return (R)this.getter.invokeWithArguments(o);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public void set(Object o, Object value) {
            try {
                this.setter.invokeWithArguments(o, value);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

