/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import customskinloader.CustomSkinLoader;
import customskinloader.utils.MinecraftUtil;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;

public class FakeClientPlayer {
    public static Map<ResourceLocation, ITextureObject> textureCache = Maps.newHashMap();

    public static HttpTexture putCache(HttpTexture threaddownloadimagedata, SkinManager.SkinTextureCallback skinAvailableCallback, ResourceLocation resourcelocation) {
        if (skinAvailableCallback instanceof LegacyBuffer) {
            textureCache.put(resourcelocation, (ITextureObject)threaddownloadimagedata);
        }
        return threaddownloadimagedata;
    }

    public static HttpTexture getDownloadImageSkin(ResourceLocation resourceLocationIn, String username) {
        TextureManager textman = MinecraftUtil.getTextureManager();
        ITextureObject ito = textman.func_110581_b(resourceLocationIn);
        if (ito == null || !(ito instanceof HttpTexture)) {
            SkinManager skinman = MinecraftUtil.getSkinManager();
            UUID offlineUUID = FakeClientPlayer.getOfflineUUID(username);
            GameProfile offlineProfile = new GameProfile(offlineUUID, username);
            ResourceLocation defaultSkin = DefaultPlayerSkin.m_118627_((UUID)offlineUUID);
            SimpleTexture defaultSkinObj = new SimpleTexture(defaultSkin);
            textman.func_110579_a(resourceLocationIn, (ITextureObject)defaultSkinObj);
            skinman.m_118817_(offlineProfile, (SkinManager.SkinTextureCallback)new LegacyBuffer(resourceLocationIn), false);
        }
        if (ito instanceof HttpTexture) {
            return (HttpTexture)ito;
        }
        return null;
    }

    public static ResourceLocation getLocationSkin(String username) {
        return new ResourceLocation("skins/legacy-" + StringUtil.m_14406_((String)username));
    }

    public static UUID getOfflineUUID(String username) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes());
    }

    public static class LegacyBuffer
    implements SkinManager.SkinTextureCallback {
        ResourceLocation resourceLocationIn;
        boolean loaded = false;

        public LegacyBuffer(ResourceLocation resourceLocationIn) {
            CustomSkinLoader.logger.debug("Loading Legacy Texture (" + resourceLocationIn + ")");
            this.resourceLocationIn = resourceLocationIn;
        }

        public void m_118856_(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
            if (typeIn != MinecraftProfileTexture.Type.SKIN || this.loaded) {
                return;
            }
            TextureManager textman = MinecraftUtil.getTextureManager();
            ITextureObject ito = textman.func_110581_b(location);
            if (ito == null) {
                ito = textureCache.get(location);
            }
            if (ito == null) {
                return;
            }
            this.loaded = true;
            textman.func_110579_a(this.resourceLocationIn, ito);
            CustomSkinLoader.logger.debug("Legacy Texture (" + this.resourceLocationIn + ") Loaded as " + ito.toString() + " (" + location + ")");
        }
    }
}

