/*
 * Decompiled with CFR 0.152.
 */
package com.suppergerrie2.alwayseat.alwayseat;

import com.suppergerrie2.alwayseat.alwayseat.Config;
import com.suppergerrie2.alwayseat.alwayseat.ServerEvents;
import com.suppergerrie2.alwayseat.alwayseat.SyncSettings;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="salwayseat")
public class AlwaysEat {
    public static final String MOD_ID = "salwayseat";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("salwayseat", "main"), () -> "1", "1"::equals, "1"::equals);

    public AlwaysEat() {
        DistExecutor.safeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> ServerEvents::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        INSTANCE.registerMessage(0, SyncSettings.class, SyncSettings::encode, SyncSettings::decode, SyncSettings::handle);
        MinecraftForge.EVENT_BUS.addListener(this::rightClickItemEvent);
    }

    public void rightClickItemEvent(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemstack = event.getItemStack();
        if (!itemstack.m_41614_()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_36391_(AlwaysEat.canEatItemWhenFull(itemstack, (LivingEntity)player))) {
            player.m_6672_(event.getHand());
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.CONSUME);
        } else {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    public static boolean canEatItemWhenFull(ItemStack item, LivingEntity livingEntity) {
        String registryName = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_())).toString();
        if (!item.m_41614_() || ((List)Config.UNEATABLE_ITEMS.get()).contains(registryName)) {
            return false;
        }
        if (Config.MODE.get() == Config.Mode.BLACKLIST) {
            if (!((List)Config.ITEM_LIST.get()).contains(registryName)) {
                return true;
            }
            return item.getFoodProperties(livingEntity).m_38747_();
        }
        if (((List)Config.ITEM_LIST.get()).contains(registryName)) {
            return true;
        }
        return item.getFoodProperties(livingEntity).m_38747_();
    }
}

