/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin.create;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import dev.ghen.thirst.content.purity.WaterPurity;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={IHaveGoggleInformation.class}, remap=false)
public interface MixinIHaveGoggleInformation {
    @Overwrite
    default public boolean containedFluidTooltip(List<Component> tooltip, boolean isPlayerSneaking, LazyOptional<IFluidHandler> handler) {
        Optional resolve = handler.resolve();
        if (resolve.isEmpty()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        Lang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            if (WaterPurity.hasPurity(fluidStack) && WaterPurity.getPurity(fluidStack) != -1) {
                int purity = WaterPurity.getPurity(fluidStack);
                ChatFormatting color = this.getPurityColor(purity);
                Lang.builder().text(WaterPurity.getPurityText(purity) + " ").add(fluidStack.getDisplayName().m_6881_()).style(color).forGoggles(tooltip, 1);
            } else {
                Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            }
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        return true;
    }

    default public ChatFormatting getPurityColor(int purity) {
        if (purity == 3) {
            return ChatFormatting.AQUA;
        }
        if (purity == 2) {
            return ChatFormatting.BLUE;
        }
        if (purity == 1) {
            return ChatFormatting.GRAY;
        }
        if (purity == 0) {
            return ChatFormatting.DARK_GRAY;
        }
        return ChatFormatting.GRAY;
    }
}

