/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.gui.appleskin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import dev.ghen.thirst.Thirst;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.foundation.gui.ThirstBarRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.helpers.KeyHelper;

@OnlyIn(value=Dist.CLIENT)
public class TooltipOverlayHandler {
    private static final ResourceLocation modIcons = Thirst.asResource("textures/gui/appleskin_icons.png");
    private static final TextureOffsets normalBarTextureOffsets = new TextureOffsets();
    private static final TextureOffsets rottenBarTextureOffsets;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new TooltipOverlayHandler());
    }

    public static void register(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(FoodTooltip.class, FoodTooltipRenderer::new);
    }

    @SubscribeEvent
    public void gatherTooltips(RenderTooltipEvent.GatherComponents event) {
        FoodTooltip foodTooltip;
        ItemStack hoveredStack;
        if (!event.isCanceled() && TooltipOverlayHandler.shouldShowTooltip(hoveredStack = event.getItemStack()) && (foodTooltip = new FoodTooltip(hoveredStack)).shouldRenderHungerBars()) {
            event.getTooltipElements().add(Either.right((Object)foodTooltip));
        }
    }

    private static boolean shouldShowTooltip(ItemStack hoveredStack) {
        boolean shouldShowTooltip;
        if (hoveredStack.m_41619_()) {
            return false;
        }
        boolean bl = shouldShowTooltip = (Boolean)ModConfig.SHOW_FOOD_VALUES_IN_TOOLTIP.get() != false && KeyHelper.isShiftKeyDown() || (Boolean)ModConfig.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP.get() != false;
        if (!shouldShowTooltip) {
            return false;
        }
        return ThirstHelper.itemRestoresThirst(hoveredStack);
    }

    static {
        TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger = 43;
        TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger = 133;
        TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger = 16;
        TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger = 124;
        TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger = 34;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull = 70;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.normalBarTextureOffsets.shankFull = 52;
        TooltipOverlayHandler.normalBarTextureOffsets.shankPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankFull + 9;
        rottenBarTextureOffsets = new TextureOffsets();
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNegativeHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerExtraHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNormalHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerPartialHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerMissingHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull = 106;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankFull = 88;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankFull + 9;
    }

    static class FoodTooltip
    implements TooltipComponent {
        private FoodValues defaultFood;
        private FoodValues modifiedFood;
        private final int biggestHunger;
        private final float biggestSaturationIncrement;
        private int hungerBars;
        private String hungerBarsText;
        private int saturationBars;
        private String saturationBarsText;
        private final ItemStack itemStack;

        FoodTooltip(ItemStack itemStack) {
            this.itemStack = itemStack;
            this.biggestHunger = ThirstHelper.getThirst(itemStack);
            this.biggestSaturationIncrement = ThirstHelper.getQuenched(itemStack);
            this.hungerBars = (int)Math.ceil((float)Math.abs(this.biggestHunger) / 2.0f);
            if (this.hungerBars > 10) {
                this.hungerBarsText = "x" + (this.biggestHunger < 0 ? -1 : 1) * this.hungerBars;
                this.hungerBars = 1;
            }
            this.saturationBars = (int)Math.ceil(Math.abs(this.biggestSaturationIncrement) / 2.0f);
            if (this.saturationBars > 10 || this.saturationBars == 0) {
                this.saturationBarsText = "x" + (this.biggestSaturationIncrement < 0.0f ? -1 : 1) * this.saturationBars;
                this.saturationBars = 1;
            }
        }

        boolean shouldRenderHungerBars() {
            return this.hungerBars > 0;
        }
    }

    static class TextureOffsets {
        int containerNegativeHunger;
        int containerExtraHunger;
        int containerNormalHunger;
        int containerPartialHunger;
        int containerMissingHunger;
        int shankMissingFull;
        int shankMissingPartial;
        int shankFull;
        int shankPartial;

        TextureOffsets() {
        }
    }

    static class FoodTooltipRenderer
    implements ClientTooltipComponent {
        private final FoodTooltip foodTooltip;

        FoodTooltipRenderer(FoodTooltip foodTooltip) {
            this.foodTooltip = foodTooltip;
        }

        public int m_142103_() {
            return 20;
        }

        public int m_142069_(@NotNull Font font) {
            int hungerBarsWidth = this.foodTooltip.hungerBars * 9;
            if (this.foodTooltip.hungerBarsText != null) {
                hungerBarsWidth += font.m_92895_(this.foodTooltip.hungerBarsText);
            }
            int saturationBarsWidth = this.foodTooltip.saturationBars * 7;
            if (this.foodTooltip.saturationBarsText != null) {
                saturationBarsWidth += font.m_92895_(this.foodTooltip.saturationBarsText);
            }
            return Math.max(hungerBarsWidth, saturationBarsWidth) + 2;
        }

        public void m_183452_(@NotNull Font font, int x, int y, @NotNull GuiGraphics guiGraphics) {
            ItemStack itemStack = this.foodTooltip.itemStack;
            Minecraft mc = Minecraft.m_91087_();
            if (!TooltipOverlayHandler.shouldShowTooltip(itemStack)) {
                return;
            }
            Screen gui = mc.f_91080_;
            if (gui == null) {
                return;
            }
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int offsetX = x;
            int offsetY = y;
            int thirst = ThirstHelper.getThirst(itemStack);
            offsetX += (this.foodTooltip.hungerBars - 1) * 9;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ThirstBarRenderer.THIRST_ICONS);
            for (int i = 0; i < this.foodTooltip.hungerBars * 2; i += 2) {
                if (thirst == i + 1) {
                    guiGraphics.m_280398_(ThirstBarRenderer.THIRST_ICONS, offsetX, offsetY, 0, 8.0f, 0.0f, 9, 9, 25, 9);
                } else {
                    guiGraphics.m_280398_(ThirstBarRenderer.THIRST_ICONS, offsetX, offsetY, 0, 16.0f, 0.0f, 9, 9, 25, 9);
                }
                offsetX -= 9;
            }
            if (this.foodTooltip.hungerBarsText != null) {
                PoseStack poseStack = guiGraphics.m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)(offsetX += 18), (float)offsetY, 0.0f);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                guiGraphics.m_280137_(font, this.foodTooltip.hungerBarsText, 2, 2, -5592406);
                poseStack.m_85849_();
            }
            offsetX = x;
            offsetY += 10;
            float modifiedSaturationIncrement = ThirstHelper.getQuenched(itemStack);
            float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
            offsetX += (this.foodTooltip.saturationBars - 1) * 7;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)modIcons);
            for (int i = 0; i < this.foodTooltip.saturationBars * 2; i += 2) {
                boolean shouldBeFaded;
                float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
                boolean bl = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
                if (shouldBeFaded) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                }
                guiGraphics.m_280398_(modIcons, offsetX, offsetY, 0, effectiveSaturationOfBar >= 1.0f ? 21.0f : ((double)effectiveSaturationOfBar > 0.5 ? 14.0f : ((double)effectiveSaturationOfBar > 0.25 ? 7.0f : (effectiveSaturationOfBar > 0.0f ? 0.0f : 28.0f))), modifiedSaturationIncrement >= 0.0f ? 27.0f : 34.0f, 7, 7, 256, 256);
                if (shouldBeFaded) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                offsetX -= 7;
            }
            if (this.foodTooltip.saturationBarsText != null) {
                PoseStack poseStack = guiGraphics.m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)(offsetX += 14), (float)offsetY, 0.0f);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                guiGraphics.m_280137_(font, this.foodTooltip.saturationBarsText, 2, 1, -5592406);
                poseStack.m_85849_();
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)modIcons);
            RenderSystem.disableDepthTest();
        }
    }
}

