/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.content.thirst;

import de.teamlapen.vampirism.util.Helper;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.damagesource.ModDamageSource;
import dev.ghen.thirst.foundation.config.CommonConfig;
import dev.ghen.thirst.foundation.network.ThirstModPacketHandler;
import dev.ghen.thirst.foundation.network.message.PlayerThirstSyncMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class PlayerThirst
implements IThirst {
    public static boolean checkTombstoneEffects = false;
    public static boolean checkFDEffects = false;
    public static boolean checkLetsDoBakeryEffects = false;
    public static boolean checkLetsDoBreweryEffects = false;
    public static boolean checkVampirismEffects = false;
    int thirst = 20;
    int quenched = 5;
    float exhaustion = 0.0f;
    int damageTimer = 0;
    int syncTimer = 0;
    float prevTickExhaustion = 0.0f;
    boolean justHealed = false;
    boolean shouldTickThirst = true;
    boolean exhaustionRecalculate = false;
    boolean init = true;

    @Override
    public int getThirst() {
        return this.thirst;
    }

    @Override
    public void setThirst(int value) {
        this.thirst = value;
    }

    @Override
    public int getQuenched() {
        return this.quenched;
    }

    @Override
    public void setQuenched(int value) {
        this.quenched = value;
    }

    @Override
    public float getExhaustion() {
        return this.exhaustion;
    }

    @Override
    public void setExhaustion(float value) {
        this.exhaustion = value;
    }

    @Override
    public void setShouldTickThirst(boolean value) {
        this.shouldTickThirst = value;
    }

    @Override
    public boolean getShouldTickThirst() {
        return this.shouldTickThirst;
    }

    @Override
    public void drink(Player player, int thirst, int quenched) {
        int extra_quenched = Math.max(this.thirst + thirst - 20, 0);
        if (!((Boolean)CommonConfig.EXTRA_HYDRATION_CONVERT_TO_QUENCHED.get()).booleanValue()) {
            extra_quenched = 0;
        }
        this.thirst = Math.min(this.thirst + thirst, 20);
        this.quenched = Math.min(this.quenched + quenched + extra_quenched, this.thirst);
    }

    @Override
    public void tick(Player player) {
        Difficulty difficulty = player.m_9236_().m_46791_();
        if (player.m_150110_().f_35934_) {
            return;
        }
        if (!this.shouldTickThirst) {
            if (this.init) {
                this.init = false;
                this.updateThirstData(player);
            }
            return;
        }
        if (checkTombstoneEffects && player.m_21220_().stream().anyMatch(e -> e.m_19576_().contains("ghostly_shape"))) {
            return;
        }
        if (checkVampirismEffects && Helper.isVampire((Player)player)) {
            return;
        }
        boolean isNourished = checkFDEffects && player.m_21023_((MobEffect)ModEffects.NOURISHMENT.get());
        boolean isHunger = player.m_21023_(MobEffects.f_19612_);
        boolean isStuffed = checkLetsDoBakeryEffects && player.m_21220_().stream().anyMatch(e -> e.m_19576_().contains("stuffed"));
        boolean isSaturated = checkLetsDoBreweryEffects && player.m_21220_().stream().anyMatch(e -> e.m_19576_().contains("saturated"));
        boolean isSitting = player.m_20159_();
        if (((Boolean)CommonConfig.DEPLETES_WHEN_NAUSEA.get()).booleanValue() && player.m_21220_().stream().anyMatch(e -> e.m_19544_().equals(MobEffects.f_19604_))) {
            this.addExhaustion(player, 0.06f);
        }
        if (isHunger) {
            this.exhaustion -= 0.005f * (float)(player.m_21124_(MobEffects.f_19612_).m_19564_() + 1) * ThirstHelper.getExhaustionBiomeModifier(player) * ThirstHelper.getExhaustionFireProtModifier(player) * ThirstHelper.getExhaustionFireResistanceModifier(player);
        }
        if (!(isSitting || isNourished || isStuffed || isSaturated)) {
            this.updateExhaustion(player);
        }
        if (this.exhaustion > 4.0f) {
            this.exhaustion -= 4.0f;
            if (this.quenched > 0) {
                --this.quenched;
            } else if (difficulty != Difficulty.PEACEFUL || ((Boolean)CommonConfig.THIRST_DEPLETION_IN_PEACEFUL.get()).booleanValue()) {
                this.thirst = Math.max(this.thirst - 1, 0);
            }
        }
        ++this.syncTimer;
        if (this.syncTimer > 10 && !player.m_9236_().m_5776_()) {
            float angle;
            if (difficulty == Difficulty.PEACEFUL && !((Boolean)CommonConfig.THIRST_DEPLETION_IN_PEACEFUL.get()).booleanValue()) {
                this.thirst = Math.min(this.thirst + 1, 20);
            }
            if ((angle = Mth.m_14177_((float)player.m_146909_())) <= -80.0f && player.m_9236_().m_46758_(player.m_20183_().m_7494_()) && ((Boolean)CommonConfig.CAN_DRINK_RAIN_WATETR.get()).booleanValue()) {
                this.thirst = Math.min(this.thirst + 1, 20);
                this.quenched = Math.min(this.quenched + 1, 20);
            }
            this.updateThirstData(player);
            this.syncTimer = 0;
        }
        if (this.thirst <= 0) {
            ++this.damageTimer;
            if (this.damageTimer >= 40) {
                if (player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || player.m_21223_() > 0.0f && difficulty == Difficulty.NORMAL) {
                    player.m_6469_(ModDamageSource.getDamageSource(player.m_9236_(), ModDamageSource.DIE_OF_THIRST_KEY), 1.0f);
                }
                this.damageTimer = 0;
            }
        }
    }

    void updateExhaustion(Player player) {
        float normalizedHungerExhaustion;
        float hungerExhaustion = player.m_36324_().m_150380_();
        float f = hungerExhaustion < this.prevTickExhaustion ? (this.exhaustionRecalculate ? hungerExhaustion + 4.0f : hungerExhaustion) : (normalizedHungerExhaustion = hungerExhaustion);
        if (this.exhaustionRecalculate) {
            this.exhaustionRecalculate = false;
        }
        float deltaExhaustion = normalizedHungerExhaustion - this.prevTickExhaustion;
        this.addExhaustion(player, deltaExhaustion);
        this.prevTickExhaustion = hungerExhaustion;
    }

    @Override
    public void updateThirstData(Player player) {
        ThirstModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PlayerThirstSyncMessage(this.thirst, this.quenched, this.exhaustion, this.shouldTickThirst));
    }

    @Override
    public void setJustHealed() {
        this.justHealed = true;
    }

    @Override
    public void ExhaustionRecalculate() {
        this.exhaustionRecalculate = true;
    }

    @Override
    public void copy(IThirst cap) {
        this.thirst = cap.getThirst();
        this.quenched = cap.getQuenched();
        this.exhaustion = cap.getExhaustion();
        this.shouldTickThirst = cap.getShouldTickThirst();
    }

    @Override
    public void addExhaustion(Player player, float amount) {
        if (!((Boolean)CommonConfig.HEALTH_REGEN_DEPLETES_HYDRATION.get()).booleanValue() && this.justHealed) {
            amount = 0.0f;
        }
        this.exhaustion = !((Boolean)CommonConfig.HEALTH_REGEN_DEHYDRATION_IS_BIOME_DEPENDENT.get()).booleanValue() && this.justHealed ? (this.exhaustion += amount) : (this.exhaustion += amount * ThirstHelper.getExhaustionBiomeModifier(player) * ThirstHelper.getExhaustionFireProtModifier(player) * ThirstHelper.getExhaustionFireResistanceModifier(player));
        if (this.justHealed) {
            this.justHealed = false;
        }
        this.updateThirstData(player);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("thirst", this.thirst);
        nbt.m_128405_("quenched", this.quenched);
        nbt.m_128350_("exhaustion", this.exhaustion);
        nbt.m_128379_("enable", this.shouldTickThirst);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.thirst = nbt.m_128451_("thirst");
        this.quenched = nbt.m_128451_("quenched");
        this.exhaustion = nbt.m_128457_("exhaustion");
        this.shouldTickThirst = !nbt.m_128441_("enable") || nbt.m_128471_("enable");
    }
}

