/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.block;

import codechicken.lib.render.block.CCBlockRendererDispatcher;
import codechicken.lib.render.block.ICCBlockRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockRenderingRegistry {
    private static boolean initialized = false;
    private static final Map<Holder<Block>, ICCBlockRenderer> blockRenderers = new HashMap<Holder<Block>, ICCBlockRenderer>();
    private static final Map<Holder<Fluid>, ICCBlockRenderer> fluidRenderers = new HashMap<Holder<Fluid>, ICCBlockRenderer>();
    private static final List<ICCBlockRenderer> globalRenderers = new ArrayList<ICCBlockRenderer>();

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        if (!initialized) {
            Minecraft mc = Minecraft.m_91087_();
            BlockRenderDispatcher parentDispatcher = mc.m_91289_();
            mc.f_91052_ = new CCBlockRendererDispatcher(parentDispatcher, mc.m_91298_());
            initialized = true;
        }
    }

    public static synchronized void registerRenderer(Block block, ICCBlockRenderer renderer) {
        Holder.Reference delegate = ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block);
        ICCBlockRenderer prev = blockRenderers.get(ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block));
        if (prev != null) {
            throw new IllegalArgumentException("Renderer already registered for block. " + ForgeRegistries.BLOCKS.getKey((Object)block));
        }
        blockRenderers.put((Holder<Block>)delegate, renderer);
    }

    public static synchronized void registerRenderer(Fluid fluid, ICCBlockRenderer renderer) {
        Holder.Reference delegate = ForgeRegistries.FLUIDS.getDelegateOrThrow((Object)fluid);
        ICCBlockRenderer prev = blockRenderers.get(delegate);
        if (prev != null) {
            throw new IllegalArgumentException("Renderer already registered for fluid. " + ForgeRegistries.FLUIDS.getKey((Object)fluid));
        }
        fluidRenderers.put((Holder<Fluid>)delegate, renderer);
    }

    public static synchronized void registerGlobalRenderer(ICCBlockRenderer renderer) {
        globalRenderers.add(renderer);
    }

    @Nullable
    static ICCBlockRenderer findFor(Block block, Predicate<ICCBlockRenderer> pred) {
        for (ICCBlockRenderer renderer : globalRenderers) {
            if (!pred.test(renderer)) continue;
            return renderer;
        }
        ICCBlockRenderer found = blockRenderers.get(ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block));
        if (found != null && pred.test(found)) {
            return found;
        }
        return null;
    }

    @Nullable
    static ICCBlockRenderer findFor(Fluid fluid, Predicate<ICCBlockRenderer> pred) {
        for (ICCBlockRenderer renderer : globalRenderers) {
            if (!pred.test(renderer)) continue;
            return renderer;
        }
        ICCBlockRenderer found = fluidRenderers.get(ForgeRegistries.FLUIDS.getDelegateOrThrow((Object)fluid));
        if (found != null && pred.test(found)) {
            return found;
        }
        return null;
    }
}

