/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.lib.ContentElement;
import codechicken.lib.gui.modular.lib.CursorHelper;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.lib.geometry.Rectangle;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiManipulable
extends GuiElement<GuiManipulable>
implements ContentElement<GuiElement<?>> {
    private final GuiElement<?> contentElement;
    private int dragXOffset = 0;
    private int dragYOffset = 0;
    private boolean isDragging = false;
    private boolean dragPos = false;
    private boolean dragTop = false;
    private boolean dragLeft = false;
    private boolean dragBottom = false;
    private boolean dragRight = false;
    private boolean enableCursors = false;
    private boolean resetOnUiInit = true;
    public int xMin = 0;
    public int xMax = 0;
    public int yMin = 0;
    public int yMax = 0;
    protected Rectangle minSize = Rectangle.create(0.0, 0.0, 50.0, 50.0);
    protected Rectangle maxSize = Rectangle.create(0.0, 0.0, 256.0, 256.0);
    protected Consumer<Boolean> onMovedCallback = null;
    protected Consumer<Boolean> onResizedCallback = null;
    protected PositionRestraint positionRestraint = draggable -> {
        int move;
        if (this.xMin < 0) {
            move = -this.xMin;
            this.xMin += move;
            this.xMax += move;
        } else if (this.xMax > this.scaledScreenWidth()) {
            move = this.xMax - this.scaledScreenWidth();
            this.xMin -= move;
            this.xMax -= move;
        }
        if (this.yMin < 0) {
            move = -this.yMin;
            this.yMin += move;
            this.yMax += move;
        } else if (this.yMax > this.scaledScreenHeight()) {
            move = this.yMax - this.scaledScreenHeight();
            this.yMin -= move;
            this.yMax -= move;
        }
    };
    private GuiElement<?> moveHandle;
    private GuiElement<?> leftHandle;
    private GuiElement<?> rightHandle;
    private GuiElement<?> topHandle;
    private GuiElement<?> bottomHandle;

    public GuiManipulable(@NotNull GuiParent<?> parent) {
        super(parent);
        this.contentElement = (GuiElement)((GuiElement)((GuiElement)((GuiElement)new GuiElement(this).constrain(GeoParam.LEFT, Constraint.dynamic(() -> this.xMin))).constrain(GeoParam.RIGHT, Constraint.dynamic(() -> this.xMax))).constrain(GeoParam.TOP, Constraint.dynamic(() -> this.yMin))).constrain(GeoParam.BOTTOM, Constraint.dynamic(() -> this.yMax));
        this.moveHandle = new GuiRectangle(this.contentElement);
        this.leftHandle = new GuiRectangle(this.contentElement);
        this.rightHandle = new GuiRectangle(this.contentElement);
        this.topHandle = new GuiRectangle(this.contentElement);
        this.bottomHandle = new GuiRectangle(this.contentElement);
    }

    public GuiManipulable resetBounds() {
        this.xMin = (int)this.xMin();
        this.xMax = (int)this.xMax();
        this.yMin = (int)this.yMin();
        this.yMax = (int)this.yMax();
        return this;
    }

    @Override
    public GuiManipulable constrain(GeoParam param, @Nullable Constraint constraint) {
        return ((GuiManipulable)super.constrain(param, constraint)).resetBounds();
    }

    @Override
    public void onScreenInit(Minecraft mc, Font font, int screenWidth, int screenHeight) {
        super.onScreenInit(mc, font, screenWidth, screenHeight);
        if (this.resetOnUiInit) {
            this.resetBounds();
        }
    }

    public GuiManipulable setResetOnUiInit(boolean resetOnUiInit) {
        this.resetOnUiInit = resetOnUiInit;
        return this;
    }

    @Override
    public GuiElement<?> getContentElement() {
        return this.contentElement;
    }

    public GuiManipulable addResizeHandles(int handleSize, boolean includeTopHandle) {
        if (includeTopHandle) {
            this.addTopHandle(handleSize);
        }
        this.addLeftHandle(handleSize);
        this.addRightHandle(handleSize);
        this.addBottomHandle(handleSize);
        return this;
    }

    public GuiManipulable addTopHandle(int handleSize) {
        ((GuiElement)((GuiElement)((GuiElement)this.topHandle.constrain(GeoParam.TOP, Constraint.match(this.contentElement.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.match(this.contentElement.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.match(this.contentElement.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, Constraint.literal(handleSize));
        return this;
    }

    public GuiManipulable setTopHandle(GuiElement<?> topHandle) {
        this.topHandle = topHandle;
        return this;
    }

    public GuiManipulable addBottomHandle(int handleSize) {
        ((GuiElement)((GuiElement)((GuiElement)this.bottomHandle.constrain(GeoParam.BOTTOM, Constraint.match(this.contentElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, Constraint.match(this.contentElement.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.match(this.contentElement.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, Constraint.literal(handleSize));
        return this;
    }

    public GuiManipulable setBottomHandle(GuiElement<?> bottomHandle) {
        this.bottomHandle = bottomHandle;
        return this;
    }

    public GuiManipulable addLeftHandle(int handleSize) {
        ((GuiElement)((GuiElement)((GuiElement)this.leftHandle.constrain(GeoParam.LEFT, Constraint.match(this.contentElement.get(GeoParam.LEFT)))).constrain(GeoParam.TOP, Constraint.match(this.contentElement.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, Constraint.match(this.contentElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, Constraint.literal(handleSize));
        return this;
    }

    public GuiManipulable setLeftHandle(GuiElement<?> leftHandle) {
        this.leftHandle = leftHandle;
        return this;
    }

    public GuiManipulable addRightHandle(int handleSize) {
        ((GuiElement)((GuiElement)((GuiElement)this.rightHandle.constrain(GeoParam.RIGHT, Constraint.match(this.contentElement.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, Constraint.match(this.contentElement.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, Constraint.match(this.contentElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, Constraint.literal(handleSize));
        return this;
    }

    public GuiManipulable setRightHandle(GuiElement<?> rightHandle) {
        this.rightHandle = rightHandle;
        return this;
    }

    public GuiManipulable addMoveHandle(int handleSize) {
        ((GuiElement)((GuiElement)((GuiElement)this.moveHandle.constrain(GeoParam.TOP, Constraint.match(this.contentElement.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.match(this.contentElement.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.match(this.contentElement.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, Constraint.literal(handleSize));
        return this;
    }

    public GuiManipulable setMoveHandle(GuiElement<?> moveHandle) {
        this.moveHandle = moveHandle;
        return this;
    }

    public GuiElement<?> getMoveHandle() {
        return this.moveHandle;
    }

    public GuiElement<?> getLeftHandle() {
        return this.leftHandle;
    }

    public GuiElement<?> getRightHandle() {
        return this.rightHandle;
    }

    public GuiElement<?> getTopHandle() {
        return this.topHandle;
    }

    public GuiElement<?> getBottomHandle() {
        return this.bottomHandle;
    }

    public GuiManipulable enableCursors(boolean enableCursors) {
        this.enableCursors = enableCursors;
        return this;
    }

    public GuiManipulable setOnMovedCallback(Runnable onMovedCallback) {
        this.onMovedCallback = finished -> onMovedCallback.run();
        return this;
    }

    public GuiManipulable setOnMovedCallback(Consumer<Boolean> onMovedCallback) {
        this.onMovedCallback = onMovedCallback;
        return this;
    }

    public GuiManipulable setOnResizedCallback(Runnable onResizedCallback) {
        this.onResizedCallback = finished -> onResizedCallback.run();
        return this;
    }

    public GuiManipulable setOnResizedCallback(Consumer<Boolean> onResizedCallback) {
        this.onResizedCallback = onResizedCallback;
        return this;
    }

    public GuiManipulable setPositionRestraint(PositionRestraint positionRestraint) {
        this.positionRestraint = positionRestraint;
        return this;
    }

    public void setMinSize(Rectangle minSize) {
        this.minSize = minSize;
    }

    public void setMaxSize(Rectangle maxSize) {
        this.maxSize = maxSize;
    }

    public Rectangle getMinSize() {
        return this.minSize;
    }

    public Rectangle getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        if (this.enableCursors) {
            boolean any;
            boolean posFlag = this.moveHandle != null && this.moveHandle.isMouseOver();
            boolean topFlag = this.topHandle != null && this.topHandle.isMouseOver();
            boolean leftFlag = this.leftHandle != null && this.leftHandle.isMouseOver();
            boolean bottomFlag = this.bottomHandle != null && this.bottomHandle.isMouseOver();
            boolean rightFlag = this.rightHandle != null && this.rightHandle.isMouseOver();
            boolean bl = any = posFlag || topFlag || leftFlag || bottomFlag || rightFlag;
            if (any) {
                if (posFlag) {
                    this.getModularGui().setCursor(CursorHelper.DRAG);
                } else if (topFlag && leftFlag || bottomFlag && rightFlag) {
                    this.getModularGui().setCursor(CursorHelper.RESIZE_TLBR);
                } else if (topFlag && rightFlag || bottomFlag && leftFlag) {
                    this.getModularGui().setCursor(CursorHelper.RESIZE_TRBL);
                } else if (topFlag || bottomFlag) {
                    this.getModularGui().setCursor(CursorHelper.RESIZE_V);
                } else {
                    this.getModularGui().setCursor(CursorHelper.RESIZE_H);
                }
            }
        }
        super.tick(mouseX, mouseY);
    }

    public void startDragging() {
        double mouseX = this.getModularGui().computeMouseX();
        double mouseY = this.getModularGui().computeMouseY();
        this.dragXOffset = (int)(mouseX - (double)this.xMin);
        this.dragYOffset = (int)(mouseY - (double)this.yMin);
        this.isDragging = true;
        this.dragPos = true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean rightFlag;
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        boolean posFlag = this.moveHandle != null && this.moveHandle.isMouseOver();
        boolean topFlag = this.topHandle != null && this.topHandle.isMouseOver();
        boolean leftFlag = this.leftHandle != null && this.leftHandle.isMouseOver();
        boolean bottomFlag = this.bottomHandle != null && this.bottomHandle.isMouseOver();
        boolean bl = rightFlag = this.rightHandle != null && this.rightHandle.isMouseOver();
        if (posFlag || topFlag || leftFlag || bottomFlag || rightFlag) {
            this.dragXOffset = (int)(mouseX - (double)this.xMin);
            this.dragYOffset = (int)(mouseY - (double)this.yMin);
            this.isDragging = true;
            if (posFlag) {
                this.dragPos = true;
            } else {
                this.dragTop = topFlag;
                this.dragLeft = leftFlag;
                this.dragBottom = bottomFlag;
                this.dragRight = rightFlag;
            }
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.isDragging) {
            int xMove = (int)(mouseX - (double)this.dragXOffset) - this.xMin;
            int yMove = (int)(mouseY - (double)this.dragYOffset) - this.yMin;
            if (this.dragPos) {
                this.xMin += xMove;
                this.xMax += xMove;
                this.yMin += yMove;
                this.yMax += yMove;
                this.validatePosition(false);
                this.onMoved(false);
            } else {
                Rectangle min = this.getMinSize();
                Rectangle max = this.getMaxSize();
                if (this.dragTop) {
                    this.yMin += yMove;
                    if ((double)(this.yMax - this.yMin) < min.height()) {
                        this.yMin = this.yMax - (int)min.height();
                    }
                    if ((double)(this.yMax - this.yMin) > max.height()) {
                        this.yMin = this.yMax - (int)max.height();
                    }
                    if (this.yMin < 0) {
                        this.yMin = 0;
                    }
                }
                if (this.dragLeft) {
                    this.xMin += xMove;
                    if ((double)(this.xMax - this.xMin) < min.width()) {
                        this.xMin = this.xMax - (int)min.width();
                    }
                    if ((double)(this.xMax - this.xMin) > max.width()) {
                        this.xMin = this.xMax - (int)max.width();
                    }
                    if (this.xMin < 0) {
                        this.xMin = 0;
                    }
                }
                if (this.dragBottom) {
                    this.yMax = this.yMin + (this.dragYOffset + yMove);
                    if ((double)(this.yMax - this.yMin) < min.height()) {
                        this.yMax = this.yMin + (int)min.height();
                    }
                    if ((double)(this.yMax - this.yMin) > max.height()) {
                        this.yMax = this.yMin + (int)max.height();
                    }
                    if (this.yMax > this.scaledScreenHeight()) {
                        this.yMax = this.scaledScreenHeight();
                    }
                }
                if (this.dragRight) {
                    this.xMax = this.xMin + (this.dragXOffset + xMove);
                    if ((double)(this.xMax - this.xMin) < min.width()) {
                        this.xMax = this.xMin + (int)min.width();
                    }
                    if ((double)(this.xMax - this.xMin) > max.width()) {
                        this.xMax = this.xMin + (int)max.width();
                    }
                    if (this.xMax > this.scaledScreenWidth()) {
                        this.xMax = this.scaledScreenWidth();
                    }
                }
                this.validatePosition(false);
                this.onResized(false);
            }
        }
        super.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button, boolean consumed) {
        if (this.isMoving()) {
            this.validatePosition(true);
            this.onMoved(true);
        }
        if (this.isResizing()) {
            this.onResized(true);
        }
        this.dragRight = false;
        this.dragBottom = false;
        this.dragLeft = false;
        this.dragTop = false;
        this.dragPos = false;
        this.isDragging = false;
        return super.mouseReleased(mouseX, mouseY, button, consumed);
    }

    protected void validatePosition(boolean finished) {
        double x = this.xMin;
        double y = this.yMin;
        this.positionRestraint.restrainPosition(this);
        if (x != (double)this.xMin || y != (double)this.yMin) {
            this.onMoved(finished);
        }
    }

    protected void onMoved(boolean finished) {
        if (this.onMovedCallback != null) {
            this.onMovedCallback.accept(finished);
        }
    }

    protected void onResized(boolean finished) {
        if (this.onResizedCallback != null) {
            this.onResizedCallback.accept(finished);
        }
    }

    public boolean isMoving() {
        return this.dragPos;
    }

    public boolean isResizing() {
        return this.dragTop || this.dragLeft || this.dragBottom || this.dragRight;
    }

    public static interface PositionRestraint {
        public void restrainPosition(GuiManipulable var1);
    }
}

