/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.gui;

import codechicken.chunkloader.api.ChunkLoaderShape;
import codechicken.chunkloader.network.ChunkLoaderCPH;
import codechicken.chunkloader.tile.TileChunkLoader;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class GuiChunkLoader
extends Screen {
    public Button laserButton;
    public Button shapeButton;
    public TileChunkLoader tile;
    private int lastRadius = -1;
    @Nullable
    private ChunkLoaderShape lastShape = null;
    private int lastButton;
    private long warningEnd = -1L;
    @Nullable
    private Component warningText;

    public GuiChunkLoader(TileChunkLoader tile) {
        super((Component)Component.m_237119_());
        this.tile = tile;
    }

    public void m_7856_() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.tile.shape, this.tile.radius + 1)).m_252987_(this.f_96543_ / 2 - 20, this.f_96544_ / 2 - 45, 20, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.tile.shape, this.tile.radius - 1)).m_252987_(this.f_96543_ / 2 - 80, this.f_96544_ / 2 - 45, 20, 20).m_253136_());
        this.laserButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), e -> {
            this.tile.renderInfo.showLasers = !this.tile.renderInfo.showLasers;
        }).m_252987_(this.f_96543_ / 2 + 7, this.f_96544_ / 2 - 60, 75, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.laserButton);
        this.shapeButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.lastButton == 1 ? this.tile.shape.prev() : this.tile.shape.next(), this.tile.radius)).m_252987_(this.f_96543_ / 2 + 7, this.f_96544_ / 2 - 37, 75, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.shapeButton);
        this.updateNames();
        super.m_7856_();
    }

    public void updateNames() {
        this.laserButton.m_93666_((Component)Component.m_237115_((String)(this.tile.renderInfo.showLasers ? "chickenchunks.gui.hidelasers" : "chickenchunks.gui.showlasers")));
        this.shapeButton.m_93666_(this.tile.shape.getTranslation());
        if (this.lastRadius != this.tile.radius || this.lastShape != this.tile.shape) {
            this.warningEnd = -1L;
            this.warningText = null;
            this.lastRadius = this.tile.radius;
            this.lastShape = this.tile.shape;
        }
    }

    public void addWarning(Component text) {
        this.warningText = text;
        this.warningEnd = System.currentTimeMillis() + 3500L;
    }

    public void m_86600_() {
        assert (this.f_96541_ != null);
        assert (this.f_96541_.f_91073_ != null);
        if (this.f_96541_.f_91073_.m_7702_(this.tile.m_58899_()) != this.tile) {
            this.f_96541_.f_91080_ = null;
            this.f_96541_.f_91067_.m_91601_();
        }
        this.updateNames();
        super.m_86600_();
    }

    public void m_88315_(GuiGraphics graphics, int p_render_1_, int p_render_2_, float p_render_3_) {
        ResourceLocation texture = new ResourceLocation("chickenchunks:textures/gui/gui_small.png");
        this.m_280273_(graphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int posx = this.f_96543_ / 2 - 88;
        int posy = this.f_96544_ / 2 - 83;
        graphics.m_280218_(texture, posx, posy, 0, 0, 176, 166);
        super.m_88315_(graphics, p_render_1_, p_render_2_, p_render_3_);
        this.drawCentered(graphics, (Component)Component.m_237115_((String)"chickenchunks.gui.name"), this.f_96543_ / 2 - 40, this.f_96544_ / 2 - 74, 0x303030);
        if (this.tile.owner != null) {
            this.drawCentered(graphics, this.tile.ownerName, this.f_96543_ / 2 + 44, this.f_96544_ / 2 - 72, 0x801080);
        }
        this.drawCentered(graphics, (Component)Component.m_237115_((String)"chickenchunks.gui.radius"), this.f_96543_ / 2 - 40, this.f_96544_ / 2 - 57, 0x404040);
        this.drawCentered(graphics, (Component)Component.m_237113_((String)("" + this.tile.radius)), this.f_96543_ / 2 - 40, this.f_96544_ / 2 - 39, 0xFFFFFF);
        int chunks = this.tile.countLoadedChunks();
        this.drawCentered(graphics, (Component)Component.m_237110_((String)(chunks == 1 ? "chickenchunks.gui.chunk" : "chickenchunks.gui.chunks"), (Object[])new Object[]{chunks}), this.f_96543_ / 2 - 39, this.f_96544_ / 2 - 21, 0x108000);
        if (this.warningText != null && this.warningEnd != -1L) {
            float fade = (float)(this.warningEnd - System.currentTimeMillis()) / 1000.0f;
            if ((double)fade <= 0.1) {
                this.warningEnd = -1L;
                this.warningText = null;
            } else {
                int alpha = fade <= 1.0f ? (int)(255.0f * fade) : 255;
                this.drawCentered(graphics, this.warningText, this.f_96543_ / 2, this.f_96544_ / 2 - 8, 0xFF5555 | (alpha & 0xFF) << 24);
            }
        }
    }

    private void drawCentered(GuiGraphics graphics, Component s, int x, int y, int colour) {
        graphics.m_280649_(this.f_96547_, s.m_7532_(), x - this.f_96547_.m_92852_((FormattedText)s) / 2, y, colour, false);
    }

    public boolean m_6375_(double x, double y, int button) {
        this.lastButton = button;
        if (button == 1) {
            button = 0;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_7043_() {
        return false;
    }
}

