/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.events;

import com.majruszlibrary.events.base.Event;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.events.type.ICancellableEvent;
import com.majruszlibrary.events.type.IEntityEvent;
import com.majruszlibrary.mixininterfaces.IMixinMob;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class OnEntitySpawned
implements ICancellableEvent,
IEntityEvent {
    public final Entity entity;
    public final boolean isLoadedFromDisk;
    public final BlockPos position;
    public final DifficultyInstance difficulty;
    @Nullable
    public final MobSpawnType mobSpawnType;
    private boolean isSpawnCancelled = false;

    public static Event<OnEntitySpawned> listen(Consumer<OnEntitySpawned> consumer) {
        return Events.get(OnEntitySpawned.class).add(consumer);
    }

    public OnEntitySpawned(Entity entity, boolean isLoadedFromDisk) {
        MobSpawnType mobSpawnType;
        this.entity = entity;
        this.isLoadedFromDisk = isLoadedFromDisk;
        this.position = entity.m_20183_();
        this.difficulty = entity.m_9236_().m_6436_(this.position);
        if (entity instanceof IMixinMob) {
            IMixinMob mob = (IMixinMob)entity;
            mobSpawnType = mob.getMobSpawnType();
        } else {
            mobSpawnType = null;
        }
        this.mobSpawnType = mobSpawnType;
    }

    @Override
    public boolean isExecutionStopped() {
        return this.isSpawnCancelled();
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    public void cancelSpawn() {
        this.isSpawnCancelled = true;
    }

    public boolean isSpawnCancelled() {
        return this.isSpawnCancelled && !(this.entity instanceof Player);
    }
}

