/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.entity;

import com.majruszlibrary.MajruszLibrary;
import com.majruszlibrary.animations.IAnimableEntity;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.AnyRot;
import com.majruszlibrary.mixin.IMixinMob;
import com.majruszlibrary.mixin.IMixinServerLevel;
import com.majruszlibrary.mixininterfaces.IMixinClientLevel;
import com.majruszlibrary.mixininterfaces.IMixinEntity;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.time.TimeHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class EntityHelper {
    public static void cheatDeath(LivingEntity entity) {
        entity.m_21153_(1.0f);
        entity.m_21219_();
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ParticleEmitter.of((ParticleOptions)ParticleTypes.f_123767_).sizeBased((Entity)entity).count(32).offset(new Vec3(0.25, 0.5, 0.25)).emit((Level)level2);
            SoundEmitter.of(SoundEvents.f_12513_).position(entity.m_20182_()).emit((Level)level2);
        }
    }

    public static boolean isOnCreativeMode(Player player) {
        return player.m_150110_().f_35937_;
    }

    public static boolean isOnSpectatorMode(Player player) {
        return player.m_5833_();
    }

    public static boolean isAnimal(@Nullable Entity entity) {
        return entity instanceof Animal;
    }

    public static boolean isHuman(Entity entity) {
        return entity instanceof Villager || entity instanceof WanderingTrader || entity instanceof Player || entity instanceof Witch || entity instanceof AbstractIllager;
    }

    public static boolean isLoaded(ServerLevel level, UUID uuid) {
        return ((IMixinServerLevel)level).getEntityManager().m_157550_(uuid);
    }

    public static boolean isOutside(Entity entity) {
        return entity.m_9236_().m_45527_(entity.m_20183_());
    }

    public static boolean isIn(Entity entity, ResourceKey<Level> level) {
        return entity.m_9236_().m_46472_().equals(level);
    }

    public static String getPlayerUUID(Player player) {
        return String.valueOf(player.m_20148_());
    }

    public static double getHealthRatio(LivingEntity entity) {
        return Mth.m_14008_((double)(entity.m_21223_() / entity.m_21233_()), (double)0.0, (double)1.0);
    }

    public static double getMissingHealthRatio(LivingEntity entity) {
        return 1.0 - EntityHelper.getHealthRatio(entity);
    }

    public static float getWalkDistanceDelta(LivingEntity entity) {
        return entity.f_19787_ - entity.f_19867_;
    }

    public static GoalSelector getGoalSelector(Mob mob) {
        return ((IMixinMob)mob).getGoalSelector();
    }

    public static GoalSelector getTargetSelector(Mob mob) {
        return ((IMixinMob)mob).getTargetSelector();
    }

    @Nullable
    public static CompoundTag getExtraTag(Entity entity) {
        return ((IMixinEntity)entity).majruszlibrary$getExtraTag();
    }

    public static CompoundTag getOrCreateExtraTag(Entity entity) {
        return ((IMixinEntity)entity).majruszlibrary$getOrCreateExtraTag();
    }

    public static void disableCurrentItem(Player player, double seconds) {
        player.m_36335_().m_41524_(player.m_21211_().m_41720_(), TimeHelper.toTicks(seconds));
        player.m_5810_();
        player.m_9236_().m_7605_((Entity)player, (byte)30);
    }

    public static boolean spawnExperience(Level level, Vec3 position, int experience) {
        return level.m_7967_((Entity)new ExperienceOrb(level, position.f_82479_, position.f_82480_, position.f_82481_, experience));
    }

    public static <Type extends Entity> Spawner<Type> createSpawner(Supplier<EntityType<Type>> type, Level level) {
        return new Spawner<Type>(type.get(), level);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesNearby(Class<EntityType> entityClass, ServerLevel level, Vec3 position, double radius) {
        return level.m_6443_(entityClass, new AABB(position, position).m_82400_(radius), entity -> AnyPos.from(position).dist(entity.m_20182_()).doubleValue() <= radius);
    }

    public static boolean destroyBlocks(Entity entity, AABB aabb, BiPredicate<BlockPos, BlockState> predicate) {
        if (!LevelHelper.isMobGriefingEnabled(entity.m_9236_())) {
            return false;
        }
        boolean destroyedAnyBlock = false;
        for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            if (!predicate.test(blockPos, entity.m_9236_().m_8055_(blockPos))) continue;
            destroyedAnyBlock |= entity.m_9236_().m_46953_(blockPos, true, entity);
        }
        return destroyedAnyBlock;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <Type> void applyToClientEntity(int entityId, Class<Type> clazz, Consumer<Type> consumer) {
        Entity entity = Side.getLocalLevel().m_6815_(entityId);
        if (clazz.isInstance(entity)) {
            consumer.accept(clazz.cast(entity));
        } else {
            ((IMixinClientLevel)Side.getLocalLevel()).majruszlibrary$delayExecution(entityId, clazz, consumer);
        }
    }

    public static AnyRot getLookRotation(Entity entity) {
        return AnyRot.y(Math.toRadians(-entity.m_146908_()) - 1.5707963267948966).rotZ(Math.toRadians(-entity.m_146909_()));
    }

    public static AnyPos getLookDirection(Entity entity) {
        return AnyPos.from(1.0, 0.0, 0.0).rot(EntityHelper.getLookRotation(entity));
    }

    public static AnyPos getDirection2d(Entity entity) {
        return AnyPos.from(1.0, 0.0, 0.0).rot(AnyRot.y(Math.toRadians(-entity.m_146908_()) - 1.5707963267948966));
    }

    public static class Spawner<Type extends Entity> {
        private final EntityType<Type> type;
        private final Level level;
        private MobSpawnType mobSpawnType = MobSpawnType.EVENT;
        private Vec3 position = null;
        private Consumer<Type> beforeEvent = null;

        public Spawner<Type> mobSpawnType(MobSpawnType mobSpawnType) {
            this.mobSpawnType = mobSpawnType;
            return this;
        }

        public Spawner<Type> position(Vec3 position) {
            this.position = position;
            return this;
        }

        public Spawner<Type> beforeEvent(Consumer<Type> beforeEvent) {
            this.beforeEvent = beforeEvent;
            return this;
        }

        @Nullable
        public Type spawn() {
            Entity entity = this.type.m_20615_(this.level);
            if (entity != null) {
                Optional.ofNullable(this.position).ifPresent(arg_0 -> ((Entity)entity).m_20219_(arg_0));
                Optional.ofNullable(this.beforeEvent).ifPresent(beforeEvent -> beforeEvent.accept(entity));
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    Level level = this.level;
                    if (level instanceof ServerLevel) {
                        ServerLevel level2 = (ServerLevel)level;
                        mob.m_6518_((ServerLevelAccessor)level2, level2.m_6436_(mob.m_20183_()), this.mobSpawnType, null, null);
                    }
                }
                if (!this.level.m_7967_(entity)) {
                    return null;
                }
            }
            return (Type)entity;
        }

        Spawner(EntityType<Type> type, Level level) {
            this.type = type;
            this.level = level;
        }
    }

    public static class EntityInvisible {
        int entityId;
        int ticks;

        public EntityInvisible(int entityId, int ticks) {
            this.entityId = entityId;
            this.ticks = ticks;
        }

        public EntityInvisible(Entity entity, int ticks) {
            this(entity.m_19879_(), ticks);
        }

        public EntityInvisible() {
            this(0, 0);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void onClient(EntityInvisible data) {
            EntityHelper.applyToClientEntity(data.entityId, IMixinEntity.class, entity -> entity.majruszlibrary$addInvisibleTicks(data.ticks));
        }

        static {
            Serializables.get(EntityInvisible.class).define("id", Reader.integer(), s -> s.entityId, (s, v) -> {
                s.entityId = v;
            }).define("ticks", Reader.integer(), s -> s.ticks, (s, v) -> {
                s.ticks = v;
            });
            Side.runOnClient(() -> () -> MajruszLibrary.ENTITY_INVISIBLE.addClientCallback(EntityInvisible::onClient));
        }
    }

    public static class EntityGlow {
        int entityId;
        int ticks;

        public EntityGlow(int entityId, int ticks) {
            this.entityId = entityId;
            this.ticks = ticks;
        }

        public EntityGlow(Entity entity, int ticks) {
            this(entity.m_19879_(), ticks);
        }

        public EntityGlow() {
            this(0, 0);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void onClient(EntityGlow data) {
            EntityHelper.applyToClientEntity(data.entityId, IMixinEntity.class, entity -> entity.majruszlibrary$addGlowTicks(data.ticks));
        }

        static {
            Serializables.get(EntityGlow.class).define("id", Reader.integer(), s -> s.entityId, (s, v) -> {
                s.entityId = v;
            }).define("ticks", Reader.integer(), s -> s.ticks, (s, v) -> {
                s.ticks = v;
            });
            Side.runOnClient(() -> () -> MajruszLibrary.ENTITY_GLOW.addClientCallback(EntityGlow::onClient));
        }
    }

    public static class EntityAnimation {
        int entityId;
        String name;
        int trackIdx;

        public EntityAnimation(int entityId, String name, int trackIdx) {
            this.entityId = entityId;
            this.name = name;
            this.trackIdx = trackIdx;
        }

        public EntityAnimation(Entity entity, String name, int trackIdx) {
            this(entity.m_19879_(), name, trackIdx);
        }

        public EntityAnimation() {
            this(0, "", 0);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void onClient(EntityAnimation data) {
            EntityHelper.applyToClientEntity(data.entityId, IAnimableEntity.class, entity -> entity.playAnimation(data.name, data.trackIdx));
        }

        static {
            Serializables.get(EntityAnimation.class).define("id", Reader.integer(), s -> s.entityId, (s, v) -> {
                s.entityId = v;
            }).define("name", Reader.string(), s -> s.name, (s, v) -> {
                s.name = v;
            }).define("trackIdx", Reader.integer(), s -> s.trackIdx, (s, v) -> {
                s.trackIdx = v;
            });
            Side.runOnClient(() -> () -> MajruszLibrary.ENTITY_ANIMATION.addClientCallback(EntityAnimation::onClient));
        }
    }
}

