/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.particle.type;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.particle.type.GenericTESParticle;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.mixin.client.GuiGraphicsAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TextParticle
extends GenericTESParticle<String> {
    protected String text;
    protected int colour = -1;

    public TextParticle(@Nullable EntityState entityState, Vector3f position, String text) {
        this(entityState, position, TESParticle.Animation.POP_OFF, text);
    }

    public TextParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, String text) {
        this(entityState, position, animation, text, TESConstants.CONFIG.defaultParticleLifespan());
    }

    public TextParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, String text, int lifespan) {
        super(entityState, position, animation, lifespan);
        this.updateData(text);
    }

    public TextParticle withColour(int colour) {
        this.colour = colour;
        return this;
    }

    public int getColour() {
        return this.colour;
    }

    @Override
    public void updateData(String data) {
        this.text = data;
    }

    @Override
    public void render(GuiGraphics guiGraphics, Minecraft mc, Font fontRenderer, float partialTick) {
        this.defaultedTextRender(mc, guiGraphics.m_280168_(), this.prevPos, this.pos, partialTick, () -> TESAPI.getConfig().particleFontStyle().render(fontRenderer, guiGraphics.m_280168_(), (Component)Component.m_237113_((String)this.text), (float)(-fontRenderer.m_92852_((FormattedText)Component.m_237113_((String)this.text))) / 2.0f, 4.0f, this.getColour(), guiGraphics.m_280091_()));
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }
}

