/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESHudElement;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.particle.TESParticleClaimant;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.TESParticleSourceHandler;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.particle.type.NumericParticle;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public final class TESAPI {
    public static void addTESParticle(TESParticle<?> particle) {
        TESParticleManager.addParticle(particle);
    }

    public static void addTESHudElement(ResourceLocation id, TESHudElement element) {
        TESHud.addHudElement(id.toString(), element);
    }

    public static boolean removeTESHudElement(ResourceLocation id) {
        return TESHud.removeHudElement(id.toString());
    }

    public static void registerParticleClaimant(ResourceLocation id, TESParticleClaimant claimant) {
        TESParticleManager.registerParticleClaimant(id, claimant);
    }

    public static void registerParticleSourceHandler(TESParticleSourceHandler handler) {
        TESParticleManager.registerParticleSourceHandler(handler);
    }

    @Nullable
    public static TESConfig getConfig() {
        return TESConstants.CONFIG;
    }

    @Nullable
    public static LivingEntity getCurrentHUDTarget() {
        return TESHud.getTargetEntity();
    }

    @Nullable
    public static EntityState getTESDataForEntity(LivingEntity entity) {
        return TESAPI.getTESDataForEntity(entity.m_19879_());
    }

    @Nullable
    public static EntityState getTESDataForEntity(int entityId) {
        return TESEntityTracking.getStateForEntityId(entityId);
    }

    public static void submitParticleClaim(ResourceLocation id, LivingEntity targetEntity, @Nullable CompoundTag additionalData) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESConstants.NETWORKING.sendParticleClaim(id, targetEntity, additionalData);
        } else {
            TESParticleManager.addParticleClaim(targetEntity.m_19879_(), id, additionalData);
        }
    }

    public static void addTESParticle(Level level, Vector3f position, Component contents) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESConstants.NETWORKING.sendParticle(level, position, contents);
        } else {
            TESParticleManager.addParticle(new ComponentParticle(null, position, contents));
        }
    }

    public static void addTESParticle(LivingEntity targetedEntity, Component contents) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESConstants.NETWORKING.sendParticle(targetedEntity, contents);
        } else {
            EntityState entityState = TESAPI.getTESDataForEntity(targetedEntity);
            if (entityState != null) {
                TESParticleManager.addParticle(new ComponentParticle(entityState, targetedEntity.m_146892_().m_252839_(), contents));
            }
        }
    }

    public static void sendParticle(Level level, Vector3f position, double value, int colour) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESConstants.NETWORKING.sendParticle(level, position, value, colour);
        } else {
            TESParticleManager.addParticle(new NumericParticle(null, position, value).withColour(colour));
        }
    }

    public static void sendParticle(LivingEntity targetedEntity, double value, int colour) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESConstants.NETWORKING.sendParticle(targetedEntity, value, colour);
        } else {
            EntityState entityState = TESAPI.getTESDataForEntity(targetedEntity);
            if (entityState != null) {
                TESParticleManager.addParticle(new NumericParticle(entityState, targetedEntity.m_146892_().m_252839_(), value).withColour(colour));
            }
        }
    }
}

