/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.mixin;

import java.util.HashSet;
import java.util.Set;
import net.blay09.mods.waystones.worldgen.WaystoneStructurePoolElement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SinglePoolElement.class})
public abstract class SinglePoolElementMixin
implements WaystoneStructurePoolElement {
    private static final Set<BlockPos> generatedWaystones = new HashSet<BlockPos>();
    private Boolean isWaystone;

    @Shadow
    public abstract String toString();

    @Override
    public boolean isWaystone() {
        if (this.isWaystone == null) {
            this.isWaystone = this.toString().contains("/waystone");
        }
        return this.isWaystone;
    }

    @Override
    public void setIsWaystone(boolean isWaystone) {
        this.isWaystone = isWaystone;
    }

    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplateManager;Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Rotation;Lnet/minecraft/world/level/levelgen/structure/BoundingBox;Lnet/minecraft/util/RandomSource;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void place(StructureTemplateManager structureTemplateManager, WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockPos blockPos2, Rotation rotation, BoundingBox boundingBox, RandomSource randomSource, boolean bl, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.isWaystone()) {
            for (BlockPos existingPos : generatedWaystones) {
                if (blockPos == existingPos || !(existingPos.m_123331_((Vec3i)blockPos) < 10000.0)) continue;
                callbackInfo.setReturnValue((Object)false);
                return;
            }
            generatedWaystones.add(blockPos);
        }
    }
}

