/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.NBTConfig;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.KillTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import questsadditions.tasks.TasksRegistry;
import questsadditions.utils.TasksUtils;

public class KillNbtTask
extends KillTask {
    public CompoundTag nbt = new CompoundTag();
    public ItemStack item = ItemStack.f_41583_;
    public boolean checkItem;
    private static final ResourceLocation ZOMBIE = new ResourceLocation("minecraft:zombie");
    private ResourceLocation entity = ZOMBIE;

    public KillNbtTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return TasksRegistry.KILLNBT;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128365_("nbt", (Tag)this.nbt);
        nbt.m_128379_("checkItem", this.checkItem);
        if (this.checkItem) {
            NBTUtils.write((CompoundTag)nbt, (String)"item", (ItemStack)this.item);
        }
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.entity = new ResourceLocation(nbt.m_128461_("entity"));
        this.nbt = nbt.m_128469_("nbt");
        this.checkItem = nbt.m_128471_("checkItem");
        if (this.checkItem) {
            this.item = NBTUtils.read((CompoundTag)nbt, (String)"item");
        }
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        buffer.m_130072_(this.entity.toString(), Short.MAX_VALUE);
        super.writeNetData(buffer);
        buffer.m_130079_(this.nbt);
        buffer.writeBoolean(this.checkItem);
        if (this.checkItem) {
            FTBQuestsNetHandler.writeItemType((FriendlyByteBuf)buffer, (ItemStack)this.item);
        }
    }

    public void readNetData(FriendlyByteBuf buffer) {
        this.entity = new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE));
        super.readNetData(buffer);
        this.nbt = buffer.m_130260_();
        this.checkItem = buffer.readBoolean();
        if (this.checkItem) {
            this.item = FTBQuestsNetHandler.readItemType((FriendlyByteBuf)buffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        ((NBTConfig)config.add("nbt", (ConfigValue)new NBTConfig(), (Object)this.nbt, v -> {
            this.nbt = v;
        }, (Object)new CompoundTag())).setNameKey("questsadditions.task.nbt");
        config.addBool("check_item", this.checkItem, v -> {
            this.checkItem = v;
        }, false).setNameKey("questsadditions.task.check_item");
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.f_41583_, true, true).setNameKey("ftbquests.task.ftbquests.item");
    }

    public void kill(TeamData teamData, LivingEntity e) {
        CompoundTag entitynbt;
        if (!teamData.isCompleted((QuestObject)this) && this.entity.equals((Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_())) && (!this.checkItem || ItemFiltersAPI.filter((ItemStack)this.item, (ItemStack)e.m_21232_().m_21205_())) && TasksUtils.Compoundequals(this.nbt, entitynbt = e.m_20240_(new CompoundTag()))) {
            teamData.addProgress((Task)this, 1L);
        }
    }
}

