/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.client.gui.CustomToast;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import questsadditions.client.RenderLiquid;
import questsadditions.network.SubmitStructurePacket;
import questsadditions.tasks.StructureTask;
import questsadditions.utils.StructureLoader;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class StructurePlacementClient {
    private static boolean locked = false;
    private static BlockPos base = BlockPos.f_121853_;
    private static Rotation rot = Rotation.CLOCKWISE_180;
    public static List<StructureTemplate.StructureBlockInfo> template = null;
    private static boolean show = false;
    private static boolean showLayers = false;
    static StructureTask currentTask;
    private static Minecraft mc;
    private static fakeworld fake;
    private static List<BlockCache> cache;

    @SubscribeEvent
    public static void render(PlayerInteractEvent.RightClickBlock event) {
        if (show && event.getSide() == LogicalSide.CLIENT) {
            if (currentTask != null && StructurePlacementClient.currentTask.rightclick_validation) {
                if (locked && currentTask != null) {
                    if (ItemFiltersAPI.filter((ItemStack)StructurePlacementClient.currentTask.item, (ItemStack)event.getItemStack())) {
                        StructurePlacementClient.submit(StructurePlacementClient.currentTask.id);
                    }
                } else if (event.getHand() == InteractionHand.OFF_HAND || !event.getItemStack().m_41619_()) {
                    locked = true;
                }
            } else {
                locked = true;
            }
        }
    }

    private static void submit(long id) {
        boolean ignoreState = StructurePlacementClient.currentTask.ignoreState;
        currentTask = null;
        show = false;
        ClientLevel world = StructurePlacementClient.mc.f_91073_;
        StructurePlacementClient.getFake().clearState();
        for (StructureTemplate.StructureBlockInfo info : template) {
            BlockState state2;
            BlockPos pos = base.m_121955_((Vec3i)info.f_74675_().m_7918_(0, 0, 1).m_7954_(rot));
            BlockState state = world.m_8055_(pos);
            if (StructureLoader.isValidState(state, state2 = info.f_74676_().m_60717_(rot), ignoreState)) continue;
            mc.m_91300_().m_94922_((Toast)new CustomToast((Component)Component.m_237113_((String)"Structure incomplete!"), ItemIcon.getItemIcon((Item)((Item)FTBQuestsItems.MISSING_ITEM.get())), (Component)Component.m_237113_((String)"Structure incomplete!")));
            StructurePlacementClient.mc.f_91074_.m_5661_((Component)Component.m_237113_((String)("Invalid block at pos " + pos)), false);
            StructurePlacementClient.mc.f_91074_.m_5661_((Component)Component.m_237113_((String)("Should be " + state2 + " but is " + state)), false);
            locked = false;
            return;
        }
        new SubmitStructurePacket(id, base, rot).sendToServer();
        locked = false;
    }

    public static boolean isLocked() {
        return locked;
    }

    public static void toggleShowStructure(String name, boolean layer, StructureTask task) {
        show = true;
        showLayers = layer;
        template = StructureLoader.get(name);
        if (template == null) {
            show = false;
            mc.m_91300_().m_94922_((Toast)new CustomToast((Component)Component.m_237113_((String)"No valid structure!"), ItemIcon.getItemIcon((Item)((Item)FTBQuestsItems.MISSING_ITEM.get())), (Component)Component.m_237113_((String)"Report this bug to modpack author!")));
        } else {
            currentTask = task;
            if (locked) {
                StructurePlacementClient.submit(task.id);
                return;
            }
            StructurePlacementClient.getFake().setBlockStates(template);
            cache.clear();
        }
        locked = false;
    }

    @SubscribeEvent
    public static void render(TickEvent.ClientTickEvent event) {
        if (show && event.phase == TickEvent.Phase.END && !locked && StructurePlacementClient.mc.f_91077_ != null && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            Rotation prevRot = rot;
            BlockPos prevBase = base;
            base = ((BlockHitResult)StructurePlacementClient.mc.f_91077_).m_82425_();
            rot = StructureLoader.getRotation(Direction.m_122364_((double)StructurePlacementClient.mc.f_91074_.m_6080_()));
            if (prevRot != rot) {
                StructurePlacementClient.getFake().setBlockStates(template);
                cache.clear();
            } else if (!prevBase.equals((Object)base)) {
                cache.clear();
            }
        }
    }

    private static fakeworld getFake() {
        if (fake == null) {
            fake = new fakeworld((Level)StructurePlacementClient.mc.f_91073_);
        }
        return fake;
    }

    private static List<BlockCache> getCache() {
        if (cache.isEmpty()) {
            for (StructureTemplate.StructureBlockInfo info : template) {
                cache.add(new BlockCache(info, base, rot));
            }
        }
        return cache;
    }

    @SubscribeEvent
    public static void render(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL && show && StructurePlacementClient.getFake().hasStates()) {
            PoseStack matrix = event.getPoseStack();
            double renderPosX = -StructurePlacementClient.mc.m_91290_().f_114358_.m_90583_().m_7096_();
            double renderPosY = -StructurePlacementClient.mc.m_91290_().f_114358_.m_90583_().m_7098_();
            double renderPosZ = -StructurePlacementClient.mc.m_91290_().f_114358_.m_90583_().m_7094_();
            BlockRenderDispatcher brd = mc.m_91289_();
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            ClientLevel world = StructurePlacementClient.mc.f_91073_;
            int layer = -1;
            matrix.m_85836_();
            matrix.m_85837_(renderPosX, renderPosY, renderPosZ);
            for (BlockCache cache : StructurePlacementClient.getCache()) {
                if (layer != -1 && cache.info.f_74675_().m_123342_() != layer && locked || world.m_8055_(cache.pos).equals(cache.state)) continue;
                if (showLayers && (cache.state.m_60819_().m_76178_() || cache.state.m_60819_().m_76170_())) {
                    layer = cache.info.f_74675_().m_123342_();
                }
                cache.render(matrix, brd, (Level)world, buffer);
            }
            buffer.m_109911_();
            matrix.m_85849_();
        }
    }

    static {
        mc = Minecraft.m_91087_();
        cache = new ArrayList<BlockCache>();
    }

    private static class fakeworld
    extends Level {
        private Map<BlockPos, BlockState> states = Maps.newHashMap();
        private Level world;
        private BlockState defaultstate = Blocks.f_50016_.m_49966_();
        private final TransientEntitySectionManager<Entity> entityStorage = new TransientEntitySectionManager(Entity.class, (LevelCallback)new EntityCallbacks());

        protected fakeworld(Level world) {
            super((WritableLevelData)world.m_6106_(), world.m_46472_(), world.m_9598_(), world.m_204156_(), world.m_46658_(), true, true, 0L, 0);
            this.world = world;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap) {
            return this.world.getCapability(cap);
        }

        public void clearState() {
            this.states.clear();
        }

        public boolean hasStates() {
            return !this.states.isEmpty();
        }

        public void setBlockStates(List<StructureTemplate.StructureBlockInfo> template) {
            this.states.clear();
            for (StructureTemplate.StructureBlockInfo info : template) {
                this.states.put(info.f_74675_().m_7954_(rot), info.f_74676_().m_60717_(rot));
            }
        }

        public void setDefault(BlockState state) {
            this.defaultstate = state;
        }

        public void resetDefault() {
            this.defaultstate = Blocks.f_50016_.m_49966_();
        }

        public BlockEntity m_7702_(BlockPos pos) {
            return this.world.m_7702_(pos);
        }

        public BlockState m_8055_(BlockPos pos) {
            return this.states.getOrDefault(pos, this.defaultstate);
        }

        public FluidState m_6425_(BlockPos pos) {
            return this.m_8055_(pos).m_60819_();
        }

        public LevelTickAccess<Block> m_183326_() {
            return this.world.m_183326_();
        }

        public LevelTickAccess<Fluid> m_183324_() {
            return this.world.m_183324_();
        }

        public ChunkSource m_7726_() {
            return this.world.m_7726_();
        }

        public void m_5898_(Player p_46771_, int p_46772_, BlockPos p_46773_, int p_46774_) {
        }

        public void m_142346_(Entity p_151549_, GameEvent p_151550_, BlockPos p_151551_) {
        }

        public RegistryAccess m_9598_() {
            return this.world.m_9598_();
        }

        public List<? extends Player> m_6907_() {
            return this.world.m_6907_();
        }

        public Holder<Biome> m_203675_(int p_46809_, int p_46810_, int p_46811_) {
            return this.world.m_203675_(p_46809_, p_46810_, p_46811_);
        }

        public float m_7717_(Direction p_45522_, boolean p_45523_) {
            return this.world.m_7717_(p_45522_, p_45523_);
        }

        public void m_7260_(BlockPos p_46612_, BlockState p_46613_, BlockState p_46614_, int p_46615_) {
        }

        public void m_6263_(Player p_46543_, double p_46544_, double p_46545_, double p_46546_, SoundEvent p_46547_, SoundSource p_46548_, float p_46549_, float p_46550_) {
        }

        public void m_6269_(Player p_46551_, Entity p_46552_, SoundEvent p_46553_, SoundSource p_46554_, float p_46555_, float p_46556_) {
        }

        public String m_46464_() {
            return this.world.m_46464_();
        }

        public Entity m_6815_(int p_46492_) {
            return this.world.m_6815_(p_46492_);
        }

        public MapItemSavedData m_7489_(String p_46650_) {
            return this.world.m_7489_(p_46650_);
        }

        public void m_142325_(String p_151533_, MapItemSavedData p_151534_) {
        }

        public int m_7354_() {
            return this.world.m_7354_();
        }

        public void m_6801_(int p_46506_, BlockPos p_46507_, int p_46508_) {
        }

        public Scoreboard m_6188_() {
            return this.world.m_6188_();
        }

        public RecipeManager m_7465_() {
            return this.world.m_7465_();
        }

        protected LevelEntityGetter<Entity> m_142646_() {
            return this.entityStorage.m_157645_();
        }

        public void m_214171_(GameEvent p_220404_, Vec3 p_220405_, GameEvent.Context p_220406_) {
        }

        public void m_214150_(Player p_220363_, double p_220364_, double p_220365_, double p_220366_, SoundEvent p_220367_, SoundSource p_220368_, float p_220369_, float p_220370_, long p_220371_) {
        }

        public FeatureFlagSet m_246046_() {
            return this.world.m_246046_();
        }

        public void m_262808_(Player p_262953_, double p_263004_, double p_263398_, double p_263376_, Holder<SoundEvent> p_263359_, SoundSource p_263020_, float p_263055_, float p_262914_, long p_262991_) {
        }

        public void m_213890_(Player p_220372_, Entity p_220373_, Holder<SoundEvent> p_263500_, SoundSource p_220375_, float p_220376_, float p_220377_, long p_220378_) {
        }

        @OnlyIn(value=Dist.CLIENT)
        final class EntityCallbacks
        implements LevelCallback<Entity> {
            EntityCallbacks() {
            }

            public void onCreated(Entity p_171696_) {
            }

            public void onDestroyed(Entity p_171700_) {
            }

            public void onTickingStart(Entity p_171704_) {
            }

            public void onTickingEnd(Entity p_171708_) {
            }

            public void onTrackingStart(Entity p_171712_) {
            }

            public void onTrackingEnd(Entity p_171716_) {
            }

            public void onSectionChange(Entity p_223609_) {
            }
        }
    }

    private static class BlockCache {
        final BlockPos pos;
        final BlockState state;
        final BlockEntity tileentity;
        final ModelData data;
        final float[] color;
        final StructureTemplate.StructureBlockInfo info;

        public BlockCache(StructureTemplate.StructureBlockInfo info, BlockPos base, Rotation rot) {
            this.info = info;
            this.pos = base.m_121955_((Vec3i)info.f_74675_().m_7918_(0, 0, 1).m_7954_(rot));
            this.state = info.f_74676_().m_60717_(rot);
            if (this.state.m_155947_()) {
                this.tileentity = BlockEntity.m_155241_((BlockPos)info.f_74675_().m_7954_(rot), (BlockState)this.state, (CompoundTag)info.f_74677_());
                this.tileentity.m_142339_((Level)StructurePlacementClient.getFake());
                this.data = this.tileentity.getModelData();
            } else {
                this.data = ModelData.EMPTY;
                this.tileentity = null;
            }
            int color = mc.m_91298_().m_92577_(this.state, null, null, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            this.color = new float[]{r, g, b};
        }

        public void render(PoseStack matrix, BlockRenderDispatcher brd, Level realWorld, MultiBufferSource.BufferSource buffer) {
            BlockState state2;
            matrix.m_85836_();
            matrix.m_252880_((float)this.pos.m_123341_(), (float)this.pos.m_123342_(), (float)this.pos.m_123343_());
            if (this.tileentity != null) {
                StructurePlacementClient.getFake().setDefault(this.state);
                mc.m_167982_().m_112272_(this.tileentity, matrix, (MultiBufferSource)buffer, 0xF400F0, OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.3f), (int)(realWorld.m_8055_(this.pos).m_60795_() ? 10 : 3)));
                StructurePlacementClient.getFake().resetDefault();
            }
            if ((state2 = this.state).m_60795_()) {
                state2 = realWorld.m_8055_(this.pos);
            }
            BakedModel model = brd.m_110910_(state2);
            if (!state2.m_60819_().m_76178_()) {
                RenderLiquid.tesselate(matrix.m_85850_().m_252922_(), (BlockAndTintGetter)StructurePlacementClient.getFake(), this.info.f_74675_().m_7954_(rot), buffer.m_6299_(render.LiquidPreview), state2.m_60819_());
            }
            if (state2.m_60799_() != RenderShape.INVISIBLE) {
                brd.m_110937_().renderModel(matrix.m_85850_(), buffer.m_6299_(render.preview), state2, model, this.color[0], this.color[1], this.color[2], 0xF400F0, OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.3f), (int)(realWorld.m_8055_(this.pos).m_60795_() ? 10 : 3)), this.data, render.preview);
            }
            matrix.m_85849_();
        }
    }

    public static class render
    extends RenderType {
        public static final RenderType preview = new render("preview_white", true, DefaultVertexFormat.f_85812_, (ImmutableList<RenderStateShard>)ImmutableList.of((Object)f_110146_, (Object)f_173113_, (Object)f_110139_, (Object)f_110111_, (Object)f_110158_, (Object)f_110152_, (Object)f_110154_, (Object)f_110117_, (Object)f_110123_, (Object)f_110148_, (Object)f_110114_, (Object)f_110130_, (Object[])new RenderStateShard[0]));
        public static final RenderType LiquidPreview = new render("LiquidPreview", false, DefaultVertexFormat.f_85811_, (ImmutableList<RenderStateShard>)ImmutableList.of((Object)f_110146_, (Object)f_173108_, (Object)f_110139_, (Object)f_110111_, (Object)f_110158_, (Object)f_110152_, (Object)f_110154_, (Object)f_110117_, (Object)f_110123_, (Object)f_110148_, (Object)f_110114_, (Object)f_110130_, (Object[])new RenderStateShard[0]));

        private render(String name, boolean alpha, VertexFormat format, ImmutableList<RenderStateShard> phases) {
            super(name, format, VertexFormat.Mode.QUADS, 256, true, true, alpha ? () -> {
                phases.forEach(RenderStateShard::m_110185_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.69f);
            } : () -> phases.forEach(RenderStateShard::m_110185_), () -> phases.forEach(RenderStateShard::m_110188_));
        }
    }
}

